/**
 * przykład klas abstrakcyjnych
 */
abstract class Person {
  String firstName;
  String lastName;

  Person(this.firstName, this.lastName);

  String get fullName;
}

class Student extends Person {
  String nickName;

  Student(String firstName, String lastName, this.nickName)
      : super(firstName, lastName);

  @override
  String get fullName => "$firstName $lastName";

  @override
  String toString() => "$fullName, also known as $nickName";
}

main() {
  Person student = new Student("Clark", "Kent", "Kal-El"); // działa tak, jak tworzymy instancję podtypu
   
   // Person p = new Person(); 
   // nie można utworzyć instancji klas abstrakcyjnych

  print(student); 
}
