/**
 * Definicja biblioteki Person w jednym pliku
 * wszystkie powiązane klasy są zdefiniowane w tym jednym pliku
 * zauważ, że pole _type jest dostępne we wszystkich klasach, jest prywatne w bibliotece (ten plik)
 */
class Person {
  String firstName;
  String lastName;
  PersonType _type;

  Person({this.firstName, this.lastName});

  String toString() => "($_type): $firstName $lastName";
}

enum PersonType { student, employee }

class Student extends Person {
  Student({firstName, lastName})
      : super(firstName: firstName, lastName: lastName) {
    _type = PersonType.student;
  }
}

class Programmer extends Person {
  Programmer({firstName, lastName})
      : super(firstName: firstName, lastName: lastName) {
    _type = PersonType.employee;
  }
}
