/**
 * przykład dla domieszek
 */
class Person {
  String firstName;
  String lastName;


  Person({this.firstName, this.lastName});

  String get fullName => "$firstName $lastName";
}

// Domieszki ograniczone słowem kluczowym „on” wymagają, aby klasa docelowa
// miałą konstruktora bez argumentów.
// W chwili pisania tej książki składnia domieszek jest nowa i mogła ulec zmianie podczas tworzenia
class Developer extends Person {
  Developer({firstName, lastName})
      : super(firstName: firstName, lastName: lastName);
}

mixin ProgrammingSkills on Developer {
  coding() {
    print("writing code...");
  }
}

mixin ManagementSkills on Developer {
  manage() {
    print("managing project...");
  }
}

// ten kod nie kompiluje się, ponieważ ProgrammingSkills to domieszka, a nie klasa
// class AdvancedProgrammingSkills extends ProgrammingSkills {
//   makingCoffe() {
//     print("making coffe...");
//   }
// }

class SeniorDeveloper extends Developer
    with ProgrammingSkills, ManagementSkills {
  SeniorDeveloper({String firstName, String lastName})
      : super(firstName: firstName, lastName: lastName);
}

class JuniorDeveloper extends Developer with ProgrammingSkills {}

main() {
  var p = new SeniorDeveloper(firstName: "clark", lastName: "kent");
  p.coding();
}
