CREATE TABLE `users`
(
  `id` int(11) NOT NULL auto_increment,
  `username` varchar(25) default NULL,
  `password` varchar(40) default NULL,
  `active` varchar(1) default '1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE `categories`
(
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) default NULL,
  `active` varchar(1) default '1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE `tracking`
(
  `id` int(11) NOT NULL auto_increment,
  `userId` int(11) default NULL,
  `videoId` int(11) default NULL,
  `count` int(11) default NULL,
  PRIMARY KEY  (`id`),
  KEY `userID` (`userId`)
) ENGINE=MyISAM;

CREATE TABLE `videos`
(
  `id` int(11) NOT NULL auto_increment,
  `catId` int(11) default NULL,
  `name` varchar(200) default NULL,
  `src` varchar(200) default NULL,
  `description` text,
  `count` int(11) default 0,
  `active` varchar(1) default '1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;


/*

Canned Row Data for testing

*/

INSERT INTO users (username, password) VALUES ('gosc', MD5('haslo'));
INSERT INTO users (username, password) VALUES ('tymek', MD5('postrzelony'));

INSERT INTO categories (name) VALUES ('Kategoria 1');
INSERT INTO categories (name) VALUES ('Kategoria 2');
INSERT INTO categories (name) VALUES ('Kategoria 3');

INSERT INTO videos (catId, name, src, description) VALUES (1, 'Film testowy 1:1', 'sample.flv', 'Bardzo fajny film');
INSERT INTO videos (catId, name, src, description) VALUES (1, 'Film testowy 1:2', 'sample.flv', 'Bardzo fajny film');

INSERT INTO videos (catId, name, src, description) VALUES (2, 'Film testowy 2:1', 'sample.flv', 'Bardzo fajny film');
INSERT INTO videos (catId, name, src, description) VALUES (2, 'Film testowy 2:2', 'sample.flv', 'Bardzo fajny film');
INSERT INTO videos (catId, name, src, description) VALUES (2, 'Film testowy 2:3', 'sample.flv', 'Bardzo fajny film');
INSERT INTO videos (catId, name, src, description) VALUES (2, 'Film testowy 2:4', 'sample.flv', 'Bardzo fajny film');
INSERT INTO videos (catId, name, src, description) VALUES (2, 'Film testowy 2:5', 'sample.flv', 'Bardzo fajny film');
INSERT INTO videos (catId, name, src, description) VALUES (2, 'Film testowy 2:6', 'sample.flv', 'Bardzo fajny film');
INSERT INTO videos (catId, name, src, description) VALUES (2, 'Film testowy 2:7', 'sample.flv', 'Bardzo fajny film');
INSERT INTO videos (catId, name, src, description) VALUES (2, 'Film testowy 2:8', 'sample.flv', 'Bardzo fajny film');

INSERT INTO videos (catId, name, src, description) VALUES (3, 'Film testowy 3:1', 'sample.flv', 'Bardzo fajny film');
