var penMC:MovieClip;
var isDrawing:Boolean = false;
var penTipSize:uint = 1;
var penColor:Number = 0x000000;

//var phpFile:String = "http://localhost/helion/r13/DrawingGD/ImageGenerator.php";
var phpFile:String = "http://10.0.0.2/~pawel/ImageGenerator.php";

function init():void
{
	penMC = new MovieClip();
	stage.addEventListener(MouseEvent.MOUSE_DOWN, startDrawing);
	stage.addEventListener(MouseEvent.MOUSE_UP, stopDrawing);
	stage.addEventListener(MouseEvent.MOUSE_MOVE, drawing);
	toolsMC.generateMC.addEventListener(MouseEvent.CLICK, generateImage);
	addChild(penMC);
	
	toolsMC.buildingImageMC.visible = false;
	
	toolsMC.swatchPurpleMC.addEventListener(MouseEvent.CLICK, function():void 
	{ 
		penColor = 0x9999CC;
	});
	toolsMC.swatchBlueMC.addEventListener(MouseEvent.CLICK, function():void 
	{ 
		penColor = 0x0000FF;
	});
	toolsMC.swatchRedMC.addEventListener(MouseEvent.CLICK, function():void 
	{ 
		penColor = 0xFF0000;
	});
	toolsMC.swatchGreenMC.addEventListener(MouseEvent.CLICK, function():void 
	{ 
		penColor = 0x00FF00;
	});
	toolsMC.swatchOrangeMC.addEventListener(MouseEvent.CLICK, function():void 
	{ 
		penColor = 0xFF9900;
	});
	toolsMC.swatchBlackMC.addEventListener(MouseEvent.CLICK, function():void 
	{ 
		penColor = 0x000000;
	});
	
	toolsMC.brushSize1MC.addEventListener(MouseEvent.CLICK, function():void 
	{ 
		penTipSize = 1;
	});
	toolsMC.brushSize2MC.addEventListener(MouseEvent.CLICK, function():void 
	{ 
		penTipSize = 2;
	});

	toolsMC.brushSize4MC.addEventListener(MouseEvent.CLICK, function():void 
	{ 
		penTipSize = 4;
	});

	toolsMC.brushSize6MC.addEventListener(MouseEvent.CLICK, function():void 
	{ 
		penTipSize = 6;
	});

	swapChildren(toolsMC, penMC);
}

function generateImage(e:MouseEvent):void
{
	var width:uint = penMC.width;
	var height:uint = penMC.height;
	
	toolsMC.buildingImageMC.visible = true;
	
	var bmp:BitmapData = new BitmapData(width, height, true, 0xFFFFFF);
	bmp.draw(penMC);
	
	var xml:String = "<points>";
		
	for(var i:uint=0; i < width; i++)
	{
		for(var j:uint=0; j < height; j++)
		{		
			var color:String = bmp.getPixel(i, j).toString(16);
			
			if(color == "0")
			{
				color = "FFFFFF";
			}
		
			xml += "<point>";
			xml += "	<x>" + i + "</x>";
			xml += "	<y>" + j + "</y>";
			xml += "	<c>" +  color + "</c>";
			xml += "</point>";
		}
	}
	
	xml += "</points>";
	
	var urlVariables:URLVariables = new URLVariables();
	urlVariables.width = width;
	urlVariables.height = height;
	urlVariables.pointData = xml;
	
	var urlRequest:URLRequest = new URLRequest(phpFile);
	urlRequest.method = URLRequestMethod.POST;
	urlRequest.data = urlVariables;
	sendToURL(urlRequest);
	
	//trace(xml);
}

function imageGenerated(e:Event):void
{
	toolsMC.buildingImageMC.visible = false;
}

function startDrawing(e:MouseEvent):void
{
	trace("Start Drawing");
	isDrawing = true;
	penMC.graphics.lineStyle(penTipSize, penColor, 1.0);
	penMC.graphics.moveTo(mouseX, mouseY);
}

function drawing(e:MouseEvent):void
{
	if(isDrawing)
	{
		penMC.graphics.lineTo(mouseX, mouseY);
	}
}

function stopDrawing(e:MouseEvent):void
{
	trace("Stop Drawing");
	isDrawing = false;
}

init();