﻿package  
{
	import flash.display.MovieClip;
	import flash.events.*;
	import flash.net.URLRequest;
	import flash.net.URLVariables;
	import flash.net.URLLoader;

	public class BookSearch extends MovieClip 
	{
		public var webServiceURL:String = "http://localhost/helion/r12/amazonSearch/bookSearch.php";
		
		private var bookItems:Array;
		private var bookItemsContainer:MovieClip;
		
		public function BookSearch()
		{
			bookItems = new Array();
			bookItemsContainer = new MovieClip();
			bookItemsContainer.y = 100;
			searchBtn.addEventListener(MouseEvent.CLICK, searchHandler);
			addChild(bookItemsContainer);
		}
		
		public function searchHandler(e:MouseEvent):void
		{
			if(searchTxt.text.length > 0)
			{
				removeOldResults();
				loadSearchResults(searchTxt.text);				
			}
		}
		
		public function loadSearchResults(terms:String):void
		{
			var urlVariables:URLVariables = new URLVariables();
			urlVariables.terms = terms;
				
			var urlRequest:URLRequest = new URLRequest(webServiceURL);
			urlRequest.data = urlVariables;
							
			var urlLoader:URLLoader = new URLLoader();
			urlLoader.addEventListener(Event.COMPLETE, loadedResultsHandler);
			urlLoader.load(urlRequest);		
		}
		
		public function loadedResultsHandler(e:Event):void
		{
			var urlLoader:URLLoader = URLLoader(e.target);
			var xml:XML = new XML(urlLoader.data);
			
			for each(var item in xml..book)
			{
				var bookItem:BookItem = new BookItem();
				bookItem.setValues(item..title, item..author, item..price, item..thumb);
				
				bookItem.y = (bookItems.length * (bookItem.height + 30));
				bookItems.push(bookItem);
				bookItemsContainer.addChild(bookItem);				
			}
		}
		
		private function removeOldResults():void
		{
			if(bookItems.length > 0)
			{
				bookItems = new Array();
				removeChild(bookItemsContainer);
				bookItemsContainer = new MovieClip();
				bookItemsContainer.y = 100;
				addChild(bookItemsContainer);
			}
		}
	}
}
