﻿package
{
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.net.*;
	import LoginWindow;
	
	public class VideoPlayer extends MovieClip
	{
		private var gatewayURL:String;
		private var gateway:NetConnection;
		private var selectedCatID:Number;
		private var login:LoginWindow;
				
		function VideoPlayer()
		{
			///gatewayURL = "http://localhost/flashphp/examples/ch%2017/amfphp/gateway.php";
			gatewayURL = "http://10.0.2.2/~pawel/amfphp/gateway.php";
			getCategories();
			
			videoPlayer.visible = false;
			videoListCombo.enabled = false;
			
			login = new LoginWindow();
			login.addEventListener(LoginWindow.LOGIN_ATTEMPT, loginHandler);

			addChild(login);
			
			login.redraw();
		}

		public function getCategories():void
		{
			var responder:Responder = new Responder(categoryResponseHandler, onFault);

			gateway = new NetConnection();
			gateway.connect(gatewayURL);
			gateway.call("Categories.getCategories", responder);
		}
		private function categoryResponseHandler(response:Object):void
		{
			trace("Pobrano informacje o kategoriach: " + response.toString());
			
			videoListCombo.enabled = true;
			videoListCombo.addItem({label:'Wybierz kategorię...', data:-1});
			for each(var item in response)
			{
				videoListCombo.addItem({label:item.name, data:item.id});
			}
			videoListCombo.addEventListener(Event.CHANGE, categoryHandler);
		}
		private function categoryHandler(e:Event):void
		{
			var id:Number = e.currentTarget.selectedItem.data;
			if(id == -1) return;
			
			selectedCatID = id;
			
			trace("Pobrano kategorię nr: " + id);
			getVideos();
		}
		
		public function getVideos():void
		{
			var responder:Responder = new Responder(videosResponseHandler, onFault);

			gateway = new NetConnection();
			gateway.connect(gatewayURL);
			gateway.call("Videos.getVideos", responder, selectedCatID, '');
		}
		private function videosResponseHandler(response:Object):void
		{
			var nextY:uint = 5;
			
			trace("Pobrano informacje o filmach: " + response.toString());
				
			var listItem:MovieClip = new MovieClip();
			videoList.source = listItem;
			
			for each(var item in response)
			{
				var videoListItem:MovieClip = new VideoListItem();
				videoListItem.addEventListener(VideoListItem.ITEM_CLICK, listItemHandler);
				videoListItem.y = nextY;
				videoListItem.x = 2;
				
				videoListItem.title = item.name;
				videoListItem.desc = item.description;
				videoListItem.videoObj = item;
				videoListItem.setItem(item.vid, '', item.src);
				
				listItem.addChild(videoListItem);
				
				nextY += videoListItem.height + 2;
				
				trace("Film [" + item.vid + "] " + item.name);
				//videoListCombo.addItem({label:item.name, data:item.id});
				
				videoList.update();
			}
			//videoListCombo.addEventListener(Event.CHANGE, categoryHandler);
		}
		private function listItemHandler(e:Event):void
		{	
			trace("Pobrano film: " + e.currentTarget.source);
			
			videoMetaInfo.titleTxt.text = e.currentTarget.videoObj.name;
			videoMetaInfo.categoryTxt.text = e.currentTarget.videoObj.cat;
			videoMetaInfo.viewsTxt.text = e.currentTarget.videoObj.count;
			videoMetaInfo.descTxt.text = e.currentTarget.videoObj.description;
			
			videoPlayer.visible = true;
			videoPlayer.source = e.currentTarget.source;
			videoPlayer.play();
			
			updateVideoTracking(e.currentTarget.videoObj.vid);
		}

		private function updateVideoTracking(vid:uint):void
		{
			var responder:Responder = new Responder(updateTrackingHandler, onFault);

			gateway = new NetConnection();
			gateway.connect(gatewayURL);
			gateway.call("Videos.updatePlayCount", responder, vid);
		}
		private function updateTrackingHandler(response:Object):void
		{
			trace("Zaktualizowano licznik oglądalności, nowa wartość: " + response.count);
			videoMetaInfo.viewsTxt.text = response.count;
		}

		private function loginHandler(e:Event):void
		{
			trace("Logowanie");
			trace("Nazwa użytkownika: " + login.data.username);
			trace("Hasło: " + login.data.password);

			var responder:Responder = new Responder(loginRespHandler, onFault);
			gateway = new NetConnection();
			gateway.connect(gatewayURL);
			gateway.call("User.login", responder, login.data.username, login.data.password);
		}

		private function loginRespHandler(o:Object):void
		{
			trace("Odpowiedź: " + o.response);

			if(o.response == true)
			{
				trace("Użytkownik zalogowany");
				login.close();
			}
			else
			{
				login.responseString = "Niepoprawna nazwa użytkownika i hasło";
			}
		}

		// Funkcja obsługi blędów
		private function onFault(responds:Object):void 
		{	
			trace("Debug::Error");
			for(var i in responds)
			{
				trace("  " + responds[i]);
			}
		}
	}
}