﻿package  
{
	import flash.display.MovieClip;
	import flash.events.*;
	import flash.net.URLRequest;
	import flash.net.URLVariables;
	import flash.net.URLLoader;
	
	public class PhotoGallery extends MovieClip 
	{
		public var webServiceURL:String = "http://localhost/helion/r12/flickrGallery/photoGallery.php";
		private var photos:Array;
		private var photosContainer:MovieClip;
		
		public function PhotoGallery()
		{
			trace("Prosta wyszukiwarka korzystająca z uslugi sieciowej zostala uruchomiona");
			photos = new Array();
			photosContainer = new MovieClip();
			photosContainer.y = 75;
			searchBtn.addEventListener(MouseEvent.CLICK, searchHandler);
			addChild(photosContainer);
		}
		
		public function searchHandler(e:MouseEvent):void
		{
			if(searchTxt.text.length > 0)
			{
				removeOldPhotos();
				loadSearchResults(searchTxt.text);				
			}
		}
		
		public function loadSearchResults(tags:String):void
		{
			trace("loadSearchResults()");
			var urlVariables:URLVariables = new URLVariables();
			urlVariables.tags = tags;
				
			var urlRequest:URLRequest = new URLRequest(webServiceURL);
			urlRequest.data = urlVariables;
							
			var urlLoader:URLLoader = new URLLoader();
			urlLoader.addEventListener(Event.COMPLETE, loadedResultsHandler);
			urlLoader.load(urlRequest);		
		}
		
		public function loadedResultsHandler(e:Event):void
		{
			trace("loadedResultsHandler()");
			
			var urlLoader:URLLoader = URLLoader(e.target);
			var xml:XML = new XML(urlLoader.data);
			
			for each(var item in xml..photo)
			{
				var photoItem:PhotoItem = new PhotoItem();
				photoItem.setValues(item..title, item..thumb);
				
				photoItem.y = (photos.length * (photoItem.height + 50));
				photos.push(photoItem);
				photosContainer.addChild(photoItem);				
			}
		}
		
		private function removeOldPhotos():void
		{
			if(photos.length > 0)
			{
				photos = new Array();
				removeChild(photosContainer);
				photosContainer = new MovieClip();
				photosContainer.y = 75;
				addChild(photosContainer);
			}
		}
	}
}
