var receivingLC:LocalConnection = new LocalConnection();
receivingLC.client = this;

// uywane do automatycznego uzupeniania
//var debugTxt:TextArea = debugTxt;

function debug(str:String, level:String):void
{
	var debugLevel:String = ((typeof(level) == 'undefined') ? 'NORMAL' : level);
	var color:String = null;
	
	switch(debugLevel) 
	{
		case 'NORMAL':
			color = '#000000';
			break;
		case 'ERROR':
			color = '#E60000';
			break;
		case 'NOTE':
			color = '#77C0FD';
			break;
		case 'WARNING':
			color = '#FBF400';
			break;
		case 'RESPONSE':
			color = '#27C201';
			break;
		case 'REGISTER':
			color = '#FC8AFF';
			break;
		case 'CLASS':
			color = '#FD779F';
			break;
		case 'ATTENTION':
			color = '#FF6600';
			break;
		case 'URGENT':
			color = '#FF0000';
			break;
		case 'STATUS':
			color = '#CCFF00';
			break;
	}
	
	if(color == null) 
	{
		color = '#000000';
	}
	
	debugTxt.htmlText += ("<font color=\"" + color + "\">" + str + "</font>" + "\n");
	
	var scrollPos:uint = debugTxt.verticalScrollPosition
	var maxScroll:uint = debugTxt.maxVerticalScrollPosition;
	if(scrollPos + 5 > maxScroll) 
	{
		debugTxt.verticalScrollPosition = maxScroll;
		//debugTxt.scroll = max_scroll;
	}
	
};
receivingLC.connect("remoteDebug");

function clearHandler(e:MouseEvent):void
{
	debugTxt.htmlText = "";
}

clearBtn.addEventListener(MouseEvent.CLICK, clearHandler);

// Obsuga zmiany rozmiaru
stage.scaleMode = StageScaleMode.NO_SCALE;
stage.align = StageAlign.TOP_LEFT;
stage.addEventListener(Event.RESIZE, function():void
{
	debugTxt.width = stage.stageWidth - 25;
	debugTxt.height = stage.stageHeight - 75;
	clearBtn.x = (stage.stageWidth - 12) - clearBtn.width;
	clearBtn.y = (stage.stageHeight - 12) - clearBtn.height;
});