﻿package
{

   import flash.errors.*;
   import flash.events.*;
   import flash.net.Socket;

   public class SimpleSocket extends Socket
   {

      public var host:String;
      public var port:uint;
      private var socket:Socket;

      public static var SOCK_CONNECTED:String = "onSocketConnected";
      public static var SOCK_IOERROR:String = "onSocketIOError";

      function SimpleSocket(h:String, p:uint)
      {
         host = h;
         port = p;
         socket = this;
         super(host, port);
         initListeners();
      }

      public function sendMessage(str:String):void
      {
         if (connected)
         {
            socket.writeUTFBytes(str + "\n");
         }
         else
         {
            trace("Brak połączenia z gnizdem, wiadomość nie została wysłana!");
         }
      }

      public function readMessage():void
      {
         if (connected)
         {
            var str:String = socket.readUTFBytes(socket.bytesAvailable);
            trace("Odpowiedź serwera: " + str);
         }
         else
         {
            trace("Wiadomość nie została odczytana, brak połączenia z gniazdem!");
         }
      }

      private function initListeners():void
      {
         socket.addEventListener(Event.CLOSE, closeHandler);
         socket.addEventListener(Event.CONNECT, connectHandler);
         socket.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
         socket.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityErrorHandler);
         socket.addEventListener(ProgressEvent.SOCKET_DATA, socketDataHandler);
      }

      private function closeHandler(event:Event):void 
      {
         trace("Połączenie z [" + host + "] zostało zamknięte");
      }

      private function ioErrorHandler(event:IOErrorEvent):void 
      {
         dispatchEvent(new Event(SOCK_IOERROR));
      }

      private function securityErrorHandler(event:SecurityErrorEvent):void 
      {
         trace(event.toString());
      }

      private function connectHandler(event:Event):void 
      {
         trace("Połączenie z [" + host + "] zostało nawiązane");
         dispatchEvent(new Event(SOCK_CONNECTED));
      }

      private function socketDataHandler(event:ProgressEvent):void 
      {
         readMessage();
      }
   }
}
