package model {
  public class Board {
    public static const P1:int = 1;
    public static const P2:int = 2;
    public static const NONE:int = 0;
    
    [Bindable]
    private var _data:Array;

    [Bindable]
    public var playerOneTurn:Boolean = true;
  
    public function Board() {
    }
		
    public function newGame():void {
      playerOneTurn = true;
      _data = new Array();
      for (var row:int = 0; row < 6; row++) {
        _data[row] = [NONE, NONE, NONE, NONE, NONE, NONE, NONE];
      }
    }

    public function getData(row:int, col:int):int {
      return _data[row][col];
    }

    public function playerMove(column:int):int {
      var row:int = getDropRow(column);
      if (row != -1) {
        _data[row][column] = playerOneTurn ? P1 : P2;
        playerOneTurn = !playerOneTurn;
      }
      return row;
    }

    private function getDropRow(column:int):int {
      for (var i:int = 5; i >= 0; i--) {
        if (_data[i][column] == NONE) {
          return i;
        }
      }
      return -1;
    }
	
    public function checkWinner():int {
      var rowWinner:int = getRowWinner();
      if (rowWinner != NONE) return rowWinner;
      var columnWinner:int = getColumnWinner();
      if (columnWinner != NONE) return columnWinner;
      var forwardDiagWinner:int = getForwardDiagWinner();
      if (forwardDiagWinner != NONE) return forwardDiagWinner;
      return getBackwardDiagWinner();
    }
    
    private function getRowWinner():int {
      var lenP1:int = 0;
      var lenP2:int = 0;
      for (var row:int = 0; row < 6; row++) {
        lenP1 = _data[row][0] == P1 ? 1 : 0;
        lenP2 = _data[row][0] == P2 ? 1 : 0;
        for (var col:int = 1; col < 7; col++) {
          if (_data[row][col] == P1) {
            lenP2 = 0;
            if (_data[row][col-1] == P1) {
              lenP1++;
              if (lenP1 > 3) return P1;
            } else {
              lenP1 = 1;
            }
          } else if (_data[row][col] == P2) {
            lenP1 = 0;
            if (_data[row][col-1] == P2) {
              lenP2++;
              if (lenP2 > 3) return P2;
            } else {
              lenP2 = 1;
            }
          } else {
            lenP2 = 0;
            lenP1 = 0;
          }
        }
      }
      return NONE;
    }
    
    private function getColumnWinner():int {
      var lenP1:int = 0;
      var lenP2:int = 0;
     for (var col:int = 0; col < 7; col++) {
        lenP1 = _data[0][col] == P1 ? 1 : 0;
        lenP2 = _data[0][col] == P2 ? 1 : 0;
        for (var row:int = 1; row < 6; row++) {
          if (_data[row][col] == P1) {
            lenP2 = 0;
            if (_data[row-1][col] == P1) {
              lenP1++;
              if (lenP1 > 3) return P1;
            } else {
              lenP1 = 1;
            }
          } else if (_data[row][col] == P2) {
            lenP1 = 0;
            if (_data[row-1][col] == P2) {
              lenP2++;
              if (lenP2 > 3) return P2;
            } else {
              lenP2 = 1;
            }
          } else {
            lenP2 = 0;
            lenP1 = 0;
          }
        }
      }
      return NONE;
    }
    
    private function getForwardDiagWinner():int {
      var lenP1:int = 0;
      var lenP2:int = 0;
      for (var diag:int = 3; diag <= 8; diag++) {
        var col:int = diag > 5 ? diag - 5 : 0;
        var row:int = Math.min(diag, 5); 
        lenP1 = _data[row][col] == P1 ? 1 : 0;
        lenP2 = _data[row][col] == P2 ? 1 : 0;
        while (col <= diag) {
          row = diag - col;
          if (row > 5 || col > 6) {
            col++;
            continue;
          }
          if (_data[row][col] == P1) {
            lenP2 = 0;
            if (col > 0 && row < 5 &&
                _data[row+1][col-1] == P1) {
              lenP1++;
              if (lenP1 > 3) return P1;
            } else {
              lenP1 = 1;
            }
          } else if (_data[row][col] == P2) {
            lenP1 = 0;
            if (col > 0 && row < 5 &&
                _data[row+1][col-1] == P2) {
              lenP2++;
              if (lenP2 > 3) return P2;
            } else {
              lenP2 = 1;
            }
          } else {
            lenP2 = 0;
            lenP1 = 0;
          }
          col++;
        }
      }
      return NONE;
    }
  
    private function getBackwardDiagWinner():int {
      var lenP1:int = 0;
      var lenP2:int = 0;
      for (var diag:int = 2; diag >= -3; diag--) {
        var col:int = diag < 0 ? Math.abs(diag) : 0;
        var row:int = Math.max(diag, 0); 
        lenP1 = _data[row][col] == P1 ? 1 : 0;
        lenP2 = _data[row][col] == P2 ? 1 : 0;
        while (col <= 8) {
          row++;
          col++;
          if (row > 5 || col > 6) {
            continue;
          }
          if (_data[row][col] == P1) {
            lenP2 = 0;
            if (col > 0 && row > 0 &&
                _data[row-1][col-1] == P1) {
              lenP1++;
              if (lenP1 > 3) return P1;
            } else {
              lenP1 = 1;
            }
          } else if (_data[row][col] == P2) {
            lenP1 = 0;
            if (col > 0 && row > 0 &&
                _data[row-1][col-1] == P2) {
              lenP2++;
              if (lenP2 > 3) return P2;
            } else {
              lenP2 = 1;
            }
          } else {
            lenP2 = 0;
            lenP1 = 0;
          }
        }
      }
      return NONE;
    }  
  }
}