package 
{
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.geom.Vector3D;
	import flash.ui.Keyboard;
	
	import away3d.containers.ObjectContainer3D;
	import away3d.primitives.GridPlane;
	import away3d.materials.WireColorMaterial
	import away3d.primitives.Trident;
	import away3d.primitives.Cube;
	import away3d.containers.View3D;
	
	public class moveExample extends Sprite 
	{
		private var view:View3D;
		private var cb:Cube;
		private var t:Trident;
		private var m:WireColorMaterial;
		private var obj:ObjectContainer3D;
		private var grid:GridPlane;
		
		public function moveExample():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
			//
			view = new View3D();
			view.x = 320;
			view.y = 240;
			addChild(view);
			
			grid = new GridPlane();
			grid.material = new WireColorMaterial(0xCCCCCC,{'wireColor':0xCCCCCC});
			grid.width = 2000;
			grid.height = 2000;
			grid.segmentsH = 20;
			grid.segmentsW = 20;
			view.scene.addChild(grid);
			view.camera.y = 400;
			view.camera.lookAt(new Vector3D(0, 0, 0));
			
			obj = new ObjectContainer3D();
			view.scene.addChild(obj);
			t = new Trident(100, true);
			t.pushfront = true;
			t.alpha = .5;
			cb = new Cube();
			m = new WireColorMaterial(0xCCCCCC);
			m.alpha = .5;
			cb.material = m;
			cb.pushback = true;
			obj.addChild(t);
			obj.addChild(cb);
		}
		
		private function onEnterFrame(e:Event):void
		{
			view.render();
		}
		
		private function onKeyDown(e:KeyboardEvent):void
		{
			m.alpha = 1;
			t.alpha = 1;
			
			if (e.keyCode == Keyboard.LEFT)  obj.translate(new Vector3D(-1, 0, 0), 50);
			if (e.keyCode == Keyboard.RIGHT) obj.translate(new Vector3D(1, 0, 0), 50);
			if (e.keyCode == Keyboard.UP)    obj.translate(new Vector3D(0, 1, 0), 50);
			if (e.keyCode == Keyboard.DOWN)  obj.translate(new Vector3D(0, -1, 0), 50);
			if (e.keyCode == Keyboard.W)  obj.rotateTo(0, 90, 0);
			if (e.keyCode == Keyboard.A)  obj.yaw(10);
			if (e.keyCode == Keyboard.S)  obj.pitch(10);
			if (e.keyCode == Keyboard.D)  obj.roll(10);
		}
		
		private function onKeyUp(e:KeyboardEvent):void
		{
			if (e.keyCode == Keyboard.SPACE) obj.rotateTo(0, 0, 0);
		}
	}
}