package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.events.MouseEvent;
	import flash.net.FileReference
	import flash.net.FileFilter;
	import fl.controls.Label;
	import fl.controls.Button;
	import fl.controls.TextInput;
	
	import away3d.exporters.AS3Exporter;
	import away3d.loaders.*;
	import away3d.events.Loader3DEvent;
	import away3d.events.ExporterEvent;
	
	public class AS3ExporterExample extends Sprite 
	{
		private var selectBtn:Button;
		private var exportBtn:Button;
		private var status:Label;
		private var className:TextInput;
		private var classPackage:TextInput;
		private var modelReference:FileReference;
		private var as30Reference:FileReference;
		private var model:*;
		private var as3Export:AS3Exporter;
		
		public function AS3ExporterExample():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			selectBtn = new Button();
			selectBtn.label = '1. Wybierz model';
			selectBtn.x = 20;
			selectBtn.y = 20;
			selectBtn.width = 110;
			addChild(selectBtn);
			selectBtn.addEventListener(MouseEvent.CLICK, selectModel);
			
			exportBtn = new Button();
			exportBtn.label = '3. Zapisz model jako klasę ActionScript';
			exportBtn.x = 20;
			exportBtn.y = 150;
			exportBtn.width = 214;
			addChild(exportBtn);
			exportBtn.addEventListener(MouseEvent.CLICK, exportModel);
			exportBtn.enabled = false;
			
			var step2Label:Label = new Label();
            step2Label.text = '2. Wypełnij dane dla klasy';
			step2Label.x = 20;
			step2Label.y = 55;
			step2Label.width = 330;
			addChild(step2Label);
			
			status = new Label();
            status.text = 'Status:';
			status.x = 20;
			status.y = 200;
			status.width = 330;
			addChild(status);
			
			className = new TextInput();
            className.editable = true;
			className.text = 'Model';
			className.x = 95;
			className.y = 85;
			className.width = 257;
			addChild(className);
			
			classPackage = new TextInput();
            classPackage.editable = true;
			classPackage.text = 'models.as';
			classPackage.x = 95;
			classPackage.y = 115;
			classPackage.width = 257;
			addChild(classPackage);
			
			var nameLabel:Label = new Label();
            nameLabel.text = 'Nazwa klasy:';
			nameLabel.x = 20;
			nameLabel.y = 87;
			nameLabel.width = 70;
			addChild(nameLabel);
			
			var packageLabel:Label = new Label();
            packageLabel.text = 'Pakiet:';
			packageLabel.x = 20;
			packageLabel.y = 117;
			packageLabel.width = 70;
			addChild(packageLabel);
		}
		
		private function selectModel(e:MouseEvent):void
		{
			exportBtn.enabled = false;
			model = null;
			modelReference = new FileReference();
			modelReference.addEventListener(Event.SELECT, onModelSelected);
			modelReference.browse(
			[
				new FileFilter('3DS Max (*.3ds)', '*.3ds'),
				new FileFilter('Wavefront (*.obj)', '*.obj'),
				new FileFilter('3DS Max ASCII (*.ase)', '*.ase'),
				new FileFilter('Away3D (*.awd)', '*.awd'),
				new FileFilter('Google Earth (*.kmz)', '*.kmz'),
				new FileFilter('Collada (*.dae)', '*.dae'),
				new FileFilter('Quake 2 (*.md2)', '*.md2')
			]);
		}
		
		private function onModelSelected(e:Event):void
		{
			modelReference.addEventListener(Event.COMPLETE, onModelLoaded);
			modelReference.addEventListener(IOErrorEvent.IO_ERROR, onLoadError);
			modelReference.load();
		}
		
		private function onModelLoaded(e:Event):void
		{
			modelReference.removeEventListener(Event.COMPLETE, onModelLoaded);
			modelReference.removeEventListener(IOErrorEvent.IO_ERROR, onLoadError);
			
			status.text = 'Status: Model pobrany.';
			
			switch(modelReference.type.toLowerCase())
			{
				case '.3ds':
				model = Max3DS.parse(modelReference.data);
				break;
				case '.obj':
				model = Obj.parse(modelReference.data);
				break;
				case '.ase':
				model = Ase.parse(modelReference.data);
				break;
				case '.awd':
				model = AWData.parse(modelReference.data);
				break;
				case '.kmz':
				model = Kmz.parse(modelReference.data);
				break;
				case '.dae':
				model = Collada.parse(modelReference.data);
				break;
				case '.md2':
				model = Md2.parse(modelReference.data);
				break;
			}
			as3Export = new AS3Exporter();
			as3Export.addOnExportComplete(as3ExportComplete);
			as3Export.export(model, className.text, classPackage.text);
		}
		
		private function as3ExportComplete(e:ExporterEvent):void
		{
			exportBtn.enabled = true;
		}
		
		private function exportModel(e:MouseEvent):void
		{
			as30Reference = new FileReference();
			as30Reference.addEventListener(Event.COMPLETE, onModelExported);
			as30Reference.save(as3Export.as3File, className.text+'.as');
			status.text = 'Status: ...';
		}
		
		private function onModelExported(e:Event):void
		{
			as30Reference.removeEventListener(Event.COMPLETE, onModelExported);
			status.text = 'Status: Model zapisany.';
		}
		
		private function onLoadError(e:IOErrorEvent):void
		{
			status.text = 'Status: Wystąpił błąd podczas pobierania pliku.';
		}
	}
}