package
{
	import away3d.materials.WireColorMaterial;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Vector3D;
	
	import away3d.containers.View3D;
	import away3d.containers.LODObject;
	import away3d.containers.ObjectContainer3D;
	import away3d.primitives.Sphere;
	
	public class LODObjectExample extends Sprite
	{
		private var view:View3D;
		private var reverse:Boolean = false;
		private var obj:ObjectContainer3D;
		
		public function LODObjectExample()
		{
			stage.quality = StageQuality.LOW;
			stage.align =  StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(Event.RESIZE, onResize);
			
			view = new View3D();
			addChild(view);
			//
			obj = new ObjectContainer3D();
			view.scene.addChild(obj);
			var lod0:LODObject = new LODObject(new Sphere( 
			{ 
				radius:50, 
				segmentsW:4, 
				segmentsH:4, 
				material:new WireColorMaterial(0xFF0000, { wireColor:0x000000 } ) 
			} ));
			lod0.minp = 0;
			lod0.maxp = .5;
			obj.addChild(lod0);
			//
			var lod1:LODObject = new LODObject(new Sphere( { radius:50, segmentsW:8, segmentsH:8, material:new WireColorMaterial(0xFF0000, { wireColor:0x000000 } ) } ));
			lod1.minp = .5;
			lod1.maxp = 1;
			obj.addChild(lod1);
			//
			var lod2:LODObject = new LODObject(new Sphere( { radius:50, segmentsW:12, segmentsH:12, material:new WireColorMaterial(0xFF0000, { wireColor:0xE50000 } ) } ));
			lod2.minp = 1;
			lod2.maxp = 1.5;
			obj.addChild(lod2);
			//
			var lod3:LODObject = new LODObject(new Sphere( { radius:50, segmentsW:16, segmentsH:16, material:new WireColorMaterial(0xFF0000, { wireColor:0xD00000 } ) } ));
			lod3.minp = 1.5;
			lod3.maxp = Infinity;
			obj.addChild(lod3);
			//
			onResize();
		}
		
		private function onEnterFrame(e:Event):void
		{
			if (obj.z > 1000) reverse = true;
			if (obj.z < -1000) reverse = false;
			if (reverse) obj.z -= 20; 
			else obj.z += 20;
			view.render();
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;			
		}
	}
}