package 
{
   import away3d.cameras.Camera3D;
   import away3d.containers.Scene3D;
   import away3d.containers.View3D;
   import away3d.controllers.HoverController;
   import away3d.entities.Mesh;
   import away3d.lights.PointLight;
   import away3d.materials.lightpickers.StaticLightPicker;
   import away3d.materials.methods.FresnelSpecularMethod;
   import away3d.materials.methods.SpecularShadingModel;
   import away3d.materials.TextureMaterial;
   import away3d.primitives.SkyBox;
   import away3d.primitives.SphereGeometry;
   import away3d.textures.BitmapCubeTexture;
   import away3d.textures.BitmapTexture;
   import flash.display.BitmapData;
   import flash.display.BitmapDataChannel;
   import flash.display.Sprite;
   import flash.events.Event;
   import flash.events.MouseEvent;
   import flash.geom.ColorTransform;
   import flash.geom.Point;
   
   [SWF(backgroundColor="#000000", frameRate="60", width="1024", height="768")]
   public class Main extends Sprite 
   {
      
      [Embed(source="../assets/earth.jpg")]
      public var EarthJPG:Class;
      
      [Embed(source="../assets/earthSpecular.jpg")]
      public var EarthSpecularJPG:Class;
      
      [Embed(source="../assets/earthNight.jpg")]
      public var EarthNightJPG:Class;
      
      [Embed(source="../assets/earthNormals.jpg")]
      public var EarthNormalsJPG:Class;
      
      [Embed(source="../assets/clouds.jpg")]
      public var CloudsJPG:Class;
      
      [Embed(source="../assets/space_posX.jpg")]
      public var PosXJPG:Class;
      
      [Embed(source="../assets/space_negX.jpg")]
      public var NegXJPG:Class;
      
      [Embed(source="../assets/space_posY.jpg")]
      public var PosYJPG:Class;
      
      [Embed(source="../assets/space_negY.jpg")]
      public var NegYJPG:Class;
      
      [Embed(source="../assets/space_posZ.jpg")]
      public var PosZJPG:Class;
      
      [Embed(source="../assets/space_negZ.jpg")]
      public var NegZJPG:Class;
      
      private var scene:Scene3D;
      private var camera:Camera3D;
      private var view:View3D;
      private var hoverCameraController:HoverController;
      private var light:PointLight; 
      private var lightPicker:StaticLightPicker;
      private var earthGeometry:SphereGeometry;
      private var earthMaterial:TextureMaterial;
      private var earth:Mesh;
      private var cloudsGeometry:SphereGeometry;
      private var cloudsMaterial:TextureMaterial;
      private var clouds:Mesh;
      private var spaceMaterial:BitmapCubeTexture
      private var space:SkyBox;
      
      private var mouseMove:Boolean = false;
      private var lastPanAngle:Number;
      private var lastTiltAngle:Number;
      private var lastMouseX:Number;
      private var lastMouseY:Number;
      
      public function Main():void 
      {
         if (stage) init();
         else addEventListener(Event.ADDED_TO_STAGE, init);
      }
      
      private function init(e:Event = null):void 
      {
         removeEventListener(Event.ADDED_TO_STAGE, init);
         
         scene = new Scene3D();
         camera = new Camera3D();
         hoverCameraController = new HoverController(camera, null, 180, 0, 1000);
         view = new View3D();
         view.scene = scene;
         view.camera = camera;
         addChild(view);
         
         initSpace();
         initLights();
         initEarth();
         initClouds();
         
         stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
         stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
         addEventListener(Event.ENTER_FRAME, onEnterFrame);
      }
      
      private function initLights() : void
        {
         light = new PointLight(); 
         light.x = 10000;
         light.ambient = 1;
         light.diffuse = 1;
         lightPicker = new StaticLightPicker([light]);
        }
      
      private function initEarth() : void
        {
         var fresnelSpecular:FresnelSpecularMethod = new FresnelSpecularMethod(true);
         fresnelSpecular.fresnelPower = 1;
         fresnelSpecular.normalReflectance = 0.1;
         fresnelSpecular.shadingModel = SpecularShadingModel.PHONG;
         earthGeometry = new SphereGeometry(350,200,100);
         earthMaterial = new TextureMaterial(new BitmapTexture(new EarthJPG().bitmapData));
         earthMaterial.normalMap = new BitmapTexture(new EarthNormalsJPG().bitmapData);
         earthMaterial.ambientTexture = new BitmapTexture(new EarthNightJPG().bitmapData);
         earthMaterial.specularMap = new BitmapTexture(new EarthSpecularJPG().bitmapData);
		 earthMaterial.specularMethod = fresnelSpecular;
         earthMaterial.lightPicker = lightPicker;
         earthMaterial.gloss = 5;
         earthMaterial.specular = 1;
         earthMaterial.ambientColor = 0xFFF68F;
         earthMaterial.ambient = 1;
         earth = new Mesh(earthGeometry, earthMaterial);
         view.scene.addChild(earth);
      }
     
	 private function initClouds():void
      {
         var alphaClouds:BitmapData = new BitmapData(2048, 1024, true, 4294967295);
           alphaClouds.copyChannel(new CloudsJPG().bitmapData, alphaClouds.rect, new Point(), BitmapDataChannel.RED, BitmapDataChannel.ALPHA);
         
         cloudsGeometry = new SphereGeometry(360,200,100);
            cloudsMaterial = new TextureMaterial(new BitmapTexture(alphaClouds));
         cloudsMaterial.alphaBlending = true;
            clouds = new Mesh(cloudsGeometry, cloudsMaterial);
            view.scene.addChild(clouds);
      }
      
      private function initSpace():void
      {
         spaceMaterial = new BitmapCubeTexture(new PosXJPG().bitmapData, new NegXJPG().bitmapData, new PosYJPG().bitmapData, new NegYJPG().bitmapData, new PosZJPG().bitmapData, new NegZJPG().bitmapData);
         space = new SkyBox(spaceMaterial);
         view.scene.addChild(space);
      }
      
      private function mouseDownHandler(e:MouseEvent):void
      {
         lastPanAngle = hoverCameraController.panAngle;
         lastTiltAngle = hoverCameraController.tiltAngle;
         lastMouseX = stage.mouseX;
         lastMouseY = stage.mouseY;
         mouseMove = true;
         stage.addEventListener(Event.MOUSE_LEAVE, onStageMouseLeave);
      }
      
      private function mouseUpHandler(e:MouseEvent):void
      {
         mouseMove = false;
         stage.removeEventListener(Event.MOUSE_LEAVE, onStageMouseLeave);
      }
      
      private function onStageMouseLeave(e:Event):void
      {
         mouseMove = false;
         stage.removeEventListener(Event.MOUSE_LEAVE, onStageMouseLeave);
      }
      
      private function onEnterFrame(event:Event):void
        {
         earth.rotationY -= .025;
         clouds.rotationY -= .035;
         
         if (mouseMove)
         {
            hoverCameraController.panAngle =  (stage.mouseX - lastMouseX)  * .5 + lastPanAngle;
            hoverCameraController.tiltAngle =  (stage.mouseY - lastMouseY)  * .5 + lastTiltAngle;
         }
         
         view.render();
        }
   }
}