package
{
	import away3d.containers.ObjectContainer3D;
	import away3d.cameras.lenses.*;
	import away3d.core.utils.Init;
	import away3d.loaders.Loader3D;
	import away3d.loaders.Collada;
	import flash.display.Stage;
	import flash.geom.Vector3D;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.KeyboardEvent;
	import flash.ui.Keyboard;

	public class Player extends ObjectContainer3D
	{
		private var _height:Number;
		private var _stage:Stage;
		private var _fpp:FPP;
		private var _cameraTargetPoint:Vector3D = new Vector3D();
		
		private var modelsContainerDistance:Number = 0;
		private var modelLoader:Loader3D;
		private var modelsContainer:ObjectContainer3D = new ObjectContainer3D();
		
		private var _shiftDown:Boolean = false;
		private var _leftDown:Boolean = false;
		private var _rightDown:Boolean = false;
		private var _forwardDown:Boolean = false;
		private var _backwardDown:Boolean = false;
		
		private static const WALK_SPEED:Number = 10;
		private static const RUN_SPEED:Number = 40;
		
		public function Player(stage:Stage, camera:FPP, init:Object = null):void
		{
			_stage = stage;
			_fpp = camera;
			_fpp.lens = new PerspectiveLens();
			_fpp.fov = 55;
			_height = ini.getNumber("height", 160, { min:100 } );
			_fpp.y = _height;
			addChild(_fpp);
			/*
			 * Model
			 */
			modelLoader = Collada.load('../../resources/models/dae/fpp/fpp_shotgun.DAE');
			modelLoader.addOnSuccess(modelLoaded);
			addChild(modelsContainer);
			/*
			 * 
			 */ 
			initListeners();
		}
		
		private function modelLoaded(e:Event):void
		{
			modelLoader.handle.name = "gun";
			modelsContainer.addChild(modelLoader.handle);
			modelsContainer.getChildByName("gun").y = _height - 25;
		}
		
		public function update():void
		{
			if (_fpp != null && !_fpp.freeCamera) 
			{
				_fpp.updateCamera();
				if (modelsContainer.getChildByName("gun"))
				{
					_cameraTargetPoint.x = modelsContainerDistance * Math.sin(_fpp.rotationY * _fpp.toRADS) * Math.cos(_fpp.rotationX * _fpp.toRADS) + _fpp.x;
					_cameraTargetPoint.z = modelsContainerDistance * Math.cos( _fpp.rotationY * _fpp.toRADS) * Math.cos(_fpp.rotationX * _fpp.toRADS) + _fpp.z;
					_cameraTargetPoint.y = modelsContainerDistance * Math.sin(_fpp.rotationX * _fpp.toRADS) + _fpp.y;
					
					modelsContainer.getChildByName("gun").position = _cameraTargetPoint;
					modelsContainer.getChildByName("gun").rotationY = _fpp.rotationY;
					modelsContainer.getChildByName("gun").rotationX = _fpp.rotationX;
				}
				
				if (_forwardDown)
				{
					x += _fpp.cameraDirectionPoint.x;
					z += _fpp.cameraDirectionPoint.z;
				}
				if (_backwardDown)
				{
					x -= _fpp.cameraDirectionPoint.x;
					z -= _fpp.cameraDirectionPoint.z;
				}
				if (_leftDown)
				{
					x -= _fpp.cameraDirectionPoint.z;
					z += _fpp.cameraDirectionPoint.x;
				}
				if (_rightDown)
				{
					x += _fpp.cameraDirectionPoint.z;
					z -= _fpp.cameraDirectionPoint.x;
				}
			}
		}
		
		public function get height():Number
		{
			return _height;
		}
		
		public function get fpp():FPP
		{
			return _fpp;
		}
		
		private function initListeners():void
		{
			_stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			_stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
		}
		
		private function onKeyDown(e:KeyboardEvent):void
		{
			switch(e.keyCode)
			{
				case Keyboard.SHIFT:
				_shiftDown = true;
				break;
				case Keyboard.A:
				_leftDown = true;
				break;
				case Keyboard.D:
				_rightDown = true;
				break;
				case Keyboard.W:
				_forwardDown = true;
				break;
				case Keyboard.S:
				_backwardDown = true;
				break;
				case Keyboard.SPACE:
				break;
				default:
				break;
			}
		}
		
		private function onKeyUp(e:KeyboardEvent):void
		{
			switch(e.keyCode)
			{
				case Keyboard.SHIFT:
				_shiftDown = false;
				break;
				case Keyboard.A:
				_leftDown = false;
				break;
				case Keyboard.D:
				_rightDown = false;
				break;
				case Keyboard.W:
				_forwardDown = false;
				break;
				case Keyboard.S:
				_backwardDown = false;
				break;
				case Keyboard.SPACE:
				break;
				default:
				break;
			}
		}
	}
}