package
{	
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.geom.Vector3D;
	import flash.ui.Keyboard;
	//
	import away3d.cameras.lenses.*;
	import away3d.containers.View3D;
	import away3d.containers.ObjectContainer3D;
	import away3d.primitives.Cube;
	import away3d.primitives.Plane;
	import away3d.lights.DirectionalLight3D;
    import away3d.materials.ShadingColorMaterial;
	import away3d.materials.ColorMaterial;
	
	public class LensExample extends Sprite
	{
		private var panel:LensPanel;
		private var view:View3D;
		private var upArrowDown:Boolean = false;
		private var downArrowDown:Boolean = false;
		private var leftArrowDown:Boolean = false;
		private var rightArrowDown:Boolean = false;
		private var wDown:Boolean = false;
		private var sDown:Boolean = false;
		private var aDown:Boolean = false;
		private var dDown:Boolean = false;
		private var ctrlDown:Boolean = false;
		private var spaceDown:Boolean = false;
		
		public function LensExample() 
		{
			stage.quality = StageQuality.LOW;
			stage.align =  StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(Event.RESIZE, onResize);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
			//
			view = new View3D();
			view.camera.position = new Vector3D(-1000, 500, -1000);
			addChild(view);
			var light:DirectionalLight3D = new DirectionalLight3D();
            light.direction = new Vector3D(500,-300,200);
			view.scene.addLight(light);
			view.scene.addChild(new Plane( { material:new ColorMaterial(0x999999), y: -25, width:2000, height:1000, segmentsW:10, segmentsH:10, pushback:true } ));
			for (var i:Number = -10; i < 10; i++)
			{
				addBlocks(i);
			}
			addPanel();
			onResize();
		}
		
		private function addPanel():void
		{
			panel = new LensPanel();
			addChild(panel);
			panel.addEventListener('ZoomFocusLensEvent', onPanelEvent);
			panel.addEventListener('PerspectiveLensEvent', onPanelEvent);
			panel.addEventListener('SphericalLensEvent', onPanelEvent);
			panel.addEventListener('OrthogonalLensEvent', onPanelEvent);
			panel.addEventListener('focusLessEvent', onPanelEvent);
			panel.addEventListener('focusMoreEvent', onPanelEvent);
			panel.addEventListener('zoomLessEvent', onPanelEvent);
			panel.addEventListener('zoomMoreEvent',onPanelEvent);
		}
		
		private function onPanelEvent(e:Event):void
		{
			switch(e.type)
			{
				case 'ZoomFocusLensEvent':
				{
					view.camera.lens = new ZoomFocusLens();
					break;
				}
				case 'PerspectiveLensEvent':
				{
					view.camera.lens = new PerspectiveLens();
					break;
				}
				case 'SphericalLensEvent':
				{
					view.camera.lens = new SphericalLens();
					break;
				}
				case 'OrthogonalLensEvent':
				{
					view.camera.lens = new OrthogonalLens();
					break;
				}
				case 'focusLessEvent':
				{
					view.camera.focus-=10;
					break;
				}
				case 'focusMoreEvent':
				{
					view.camera.focus+=10;
					break;
				}
				case 'zoomLessEvent':
				{
					view.camera.zoom--;
					break;
				}
				case 'zoomMoreEvent':
				{
					view.camera.zoom++;
					break;
				}
			}
		}
		
		private function addBlocks(pos:Number):void
		{
			var group:ObjectContainer3D = new ObjectContainer3D();
			group.x = pos * 100;
			for (var i:Number = -8; i < 8; i++)
			{
				var h = Math.floor(Math.random() * (1 + 300 - 25)) + 25;
				group.addChild(new Cube( { material:new ShadingColorMaterial(Math.random() * 0xFFFFFF), width:25, depth:25, height:h, y:h * .5, z:50 * i } ));
			}
			view.scene.addChild(group);
		}
		
		private function onKeyDown(e:KeyboardEvent):void
		{
			switch(e.keyCode)
			{
				case Keyboard.UP: upArrowDown = true; break;
				case Keyboard.DOWN: downArrowDown = true; break;
				case Keyboard.LEFT: leftArrowDown = true; break;
				case Keyboard.RIGHT: rightArrowDown = true; break;
				case Keyboard.W: wDown = true; break;
				case Keyboard.S: sDown = true; break;
				case Keyboard.A: aDown = true; break;
				case Keyboard.D: dDown = true; break;
				case Keyboard.SPACE: spaceDown = true; break;
				case Keyboard.CONTROL: ctrlDown = true; break;
			}
		}
		
		private function onKeyUp(e:KeyboardEvent):void
		{
			switch(e.keyCode)
			{
				case Keyboard.UP: upArrowDown = false; break;
				case Keyboard.DOWN: downArrowDown = false; break;
				case Keyboard.LEFT: leftArrowDown = false; break;
				case Keyboard.RIGHT: rightArrowDown = false; break;
				case Keyboard.W: wDown = false; break;
				case Keyboard.S: sDown = false; break;
				case Keyboard.A: aDown = false; break;
				case Keyboard.D: dDown = false; break;
				case Keyboard.SPACE: spaceDown = false; break;
				case Keyboard.CONTROL: ctrlDown = false; break;
			}
		}
		
		private function onEnterFrame(e:Event):void
		{
			if (spaceDown) view.camera.y++;
			if (ctrlDown) view.camera.y--;
			if (wDown) view.camera.moveForward(10);
			if (upArrowDown) view.camera.rotationX++;
			if (sDown) view.camera.moveBackward(10);
			if (downArrowDown) view.camera.rotationX--;
			if (aDown) view.camera.moveLeft(10);
			if (leftArrowDown) view.camera.rotationY--;
			if (dDown) view.camera.moveRight(10);
			if (rightArrowDown) view.camera.rotationY++;
			view.render();
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;
			panel.draw(stage.stageWidth, 55);
		}
	}
}