package
{	
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Vector3D;
	
	import away3d.containers.View3D;
	import away3d.containers.ObjectContainer3D;
	import away3d.materials.MovieMaterial;
	import away3d.sprites.DepthOfFieldSprite;
	//import away3d.core.utils.DofCache;
	
	public class DoFExample extends Sprite
	{
		[Embed(source="../../resources/swfs/monster.swf", symbol="Head")]
		private var MonsterHead:Class;
		
		private var view:View3D;
		private var heads:ObjectContainer3D = new ObjectContainer3D();
		
		public function DoFExample() 
		{
			stage.align =  StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(Event.RESIZE, onResize);
			//
			view = new View3D();
			view.camera.enableDof();
			view.camera.doflevels = 10;
			view.camera.aperture = 550;
			view.camera.maxblur = 5;
			view.camera.zoom = 2;
			/*DofCache.usedof=true;
			DofCache.maxblur=10;
			DofCache.focus=550;
			DofCache.aperture=45;
			DofCache.doflevels=10;*/
			addChild(view);
			view.scene.addChild(heads);
			
			var mat:MovieMaterial = new MovieMaterial(new MonsterHead());
			for (var i:uint=0; i < 100; i++)
			{
				var sp:DepthOfFieldSprite = new DepthOfFieldSprite(mat, 100, 100);
				sp.x = Math.floor(Math.random() * (1 + 900 + 600)) -600;
				sp.y = Math.floor(Math.random() * (1 + 900 + 600)) -600;
				sp.z = Math.floor(Math.random() * (1 + 900 + 600)) -600;
				sp.scaling = Math.floor(Math.random() * 10) * .1;
				heads.addSprite(sp);
			}
			onResize();
		}
		
		private function onEnterFrame(e:Event):void
		{
			heads.rotationX--;
			view.render();
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;			
		}
	}
}