package 
{
	import away3d.materials.ShadingColorMaterial;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Vector3D;
	//
	import away3d.containers.View3D;
	import away3d.containers.ObjectContainer3D;
	import away3d.lights.*;
	import away3d.materials.*;
	import away3d.primitives.Sphere;
	/**
	 * ...
	 * @author 
	 */
	public class DirectionalLight3DExample extends Sprite 
	{
		private var view:View3D;
		private var obj:ObjectContainer3D;
		private var light:DirectionalLight3D;
		
		public function DirectionalLight3DExample():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			stage.quality = StageQuality.LOW;
			stage.align =  StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			removeEventListener(Event.ADDED_TO_STAGE, init);
			stage.addEventListener(Event.RESIZE, onResize);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			
			initPanelListeners();
			
			view = new View3D();
			addChild(view);
			
			addLights();
			addObjects();			
			
			onResize();
		}
		
		private function initPanelListeners():void
		{
			panel.brightnessText.addEventListener(Event.CHANGE, updateLight);
			panel.specularText.addEventListener(Event.CHANGE, updateLight);
			panel.diffuseText.addEventListener(Event.CHANGE, updateLight);
			panel.ambientText.addEventListener(Event.CHANGE, updateLight);
			panel.xText.addEventListener(Event.CHANGE, updateLight);
			panel.yText.addEventListener(Event.CHANGE, updateLight);
			panel.zText.addEventListener(Event.CHANGE, updateLight);
		}
		
		private function addLights():void
		{
			light = new DirectionalLight3D({ color:0xFFFFFF, specular:1, diffuse:.5, ambient:.5 });
			view.scene.addLight(light);
		}
		
		private function addObjects():void
		{
			obj = new ObjectContainer3D();
			var sph1:Sphere = new Sphere( { radius:50, material:new ShadingColorMaterial(0xFF0000), x:-150 } );
			var sph2:Sphere = new Sphere( { radius:50, material:new ShadingColorMaterial(0xFF0000), x:150 } );
			obj.addChild(sph1);
			obj.addChild(sph2);
			view.scene.addChild(obj);
		}
		
		private function updateLight(e:Event):void
		{
			light.brightness = Number(panel.brightnessText.text);
			light.specular = Number(panel.specularText.text);
			light.diffuse = Number(panel.diffuseText.text);
			light.ambient = Number(panel.ambientText.text);
			light.direction = new Vector3D(Number(panel.xText.text), Number(panel.yText.text), Number(panel.zText.text));
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;			
		}
		
		private function onEnterFrame(e:Event):void
		{
			obj.rotationY--;
			view.render();
		}
	}
}