package 
{
	import away3d.sprites.MovieClipSprite;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.*;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Vector3D;
	
	import away3d.containers.View3D;
	import away3d.core.utils.Cast;
	import away3d.materials.*;
	import away3d.primitives.*;
	
	public class MaterialsExample extends MovieClip 
	{
		[Embed(source="../../resources/bitmaps/WaterNormalMap.jpg")]
		private var NormalMap:Class;
		
		[Embed(source="../../resources/bitmaps/waterMap.jpg")]
		private var WaterMap:Class;
		
		[Embed(source="../../resources/bitmaps/seaturtle.jpg")]
		private var SeaturtleBitmap:Class;
		
		[Embed(source="../../resources/bitmaps/specular.jpg")]
		private var Board:Class;
		
		[Embed(source="../../resources/swfs/form.swf")]
		private var movieMC:Class;
		
		[Embed(source="../../resources/swfs/water.swf", symbol="Water")]
		private var Water:Class;
		
		private var panel:MaterialsPanel;
		private var view:View3D;
		private var wireframe:WireframeMaterial;
		private var wirecolor:WireColorMaterial;
		private var color:ColorMaterial;
		private var enviroColor:EnviroColorMaterial;
		private var bitmap:BitmapMaterial;
		private var bitmapFile:BitmapFileMaterial;
		private var glassMaterial:GlassMaterial;
		private var enviroBitmap:EnviroBitmapMaterial;
		private var transformBitmap:TransformBitmapMaterial;
		private var animatedBitmap:AnimatedBitmapMaterial;
		private var movie:MovieMaterial;
		private var video:VideoMaterial;
		private var currentMaterial:*;
		
		private var sphere:Sphere;
		private var cube:Cube;
		private var plane:Plane;
		private var seaturtle:SeaTurtle;
		private var currentObject:*;		
		
		public function MaterialsExample():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			stage.quality = StageQuality.LOW;
			stage.align =  StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			removeEventListener(Event.ADDED_TO_STAGE, init);
			stage.addEventListener(Event.RESIZE, onResize);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			
			view = new View3D();
			addChild(view);
			initMaterials();
			initObjects();
			
			addPanel();
			onResize();
		}
		
		private function addPanel():void
		{
			panel = new MaterialsPanel();
			addChild(panel);
			panel.addEventListener('togglePauseEvent', onPanelEvent);
			panel.addEventListener('lessSegmentsEvent', onPanelEvent);
			panel.addEventListener('moreSegmentsEvent', onPanelEvent);
			panel.addEventListener('lessExponentEvent', onPanelEvent);
			panel.addEventListener('moreExponentEvent', onPanelEvent);
			panel.addEventListener('WireframeMaterialEvent', onMaterialChangeEvent);
			panel.addEventListener('WireColorMaterialEvent', onMaterialChangeEvent);
			panel.addEventListener('ColorMaterialEvent', onMaterialChangeEvent);
			panel.addEventListener('EnviroColorMaterialEvent', onMaterialChangeEvent);
			panel.addEventListener('BitmapMaterialEvent', onMaterialChangeEvent);
			panel.addEventListener('BitmapFileMaterialEvent', onMaterialChangeEvent);
			panel.addEventListener('EnviroBitmapMaterialEvent', onMaterialChangeEvent);
			panel.addEventListener('GlassMaterialEvent', onMaterialChangeEvent);
			panel.addEventListener('TransformBitmapMaterialEvent', onMaterialChangeEvent);
			panel.addEventListener('DepthBitmapMaterialEvent', onMaterialChangeEvent);
			panel.addEventListener('MovieMaterialEvent', onMaterialChangeEvent);
			panel.addEventListener('AnimatedBitmapMaterialEvent', onMaterialChangeEvent);
			panel.addEventListener('VideoMaterialEvent', onMaterialChangeEvent);
		}
		
		private function onPanelEvent(e:Event):void
		{
			switch(e.type)
			{
				case 'togglePauseEvent':
				{
					(currentMaterial as VideoMaterial).netStream.togglePause();
					break;
				}
				case 'lessSegmentsEvent':
				{
					currentObject.material.scaleX /= .5;
					currentObject.material.scaleY /= .5;
					break;
				}
				case 'moreSegmentsEvent':
				{
					currentObject.material.scaleX *= .5;
					currentObject.material.scaleY *= .5;
					break;
				}
				case 'lessExponentEvent':
				{
					if (currentMaterial.exponent >= 10) currentMaterial.exponent -= 10;
					break;
				}
				case 'moreExponentEvent':
				{
					currentMaterial.exponent += 10;
					break;
				}
			}
			trace(currentObject.material.scaleX);
		}
		
		private function initMaterials():void
		{
			var waterMap:Bitmap = new WaterMap();
			var seaturtleBitmap:Bitmap = new SeaturtleBitmap();
			var board:Bitmap = new Board();
			//WireframeMaterial
			wireframe = new WireframeMaterial(0x000000);
			
			//WireColorMaterial
			wirecolor = new WireColorMaterial(0xFF0000, { wireColor:0x000000} );
			
			//ColorMaterial
			color = new ColorMaterial(0xFF0000);
			
			//EnviroColorMaterial
			enviroColor = new EnviroColorMaterial(0xFFFFFF, waterMap.bitmapData);
			
			//BitmapMaterial
			bitmap = new BitmapMaterial(seaturtleBitmap.bitmapData);
			
			//BitmapFileMaterial
			bitmapFile = new BitmapFileMaterial('../../resources/bitmaps/road.jpg');
			
			//EnviroBitmapMaterial
			enviroBitmap = new EnviroBitmapMaterial(seaturtleBitmap.bitmapData, waterMap.bitmapData);
			
			//TransformBitmapMaterial
			transformBitmap = new TransformBitmapMaterial(board.bitmapData, { repeat:true, scaleX:1, scaleY:1 } );
			transformBitmap.globalProjection = true;
			//MovieMaterial
			movie = new MovieMaterial(new movieMC(), { interactive:true } );
			
			//AnimatedBitmapMaterial
			animatedBitmap = new AnimatedBitmapMaterial(new Water());
			
			currentMaterial = wireframe;
		}
		
		private function initObjects():void
		{
			//Sphere
			sphere = new Sphere( { material:currentMaterial, segmentsW:16, segmentsH:16 } );
			
			//Cube
			cube = new Cube( { material:currentMaterial, segmentsW:8, segmentsH:8, segmentsD:8 } );
			cube.scale(2);
			
			//Plane
			plane = new Plane( { material:currentMaterial, yUp:false, bothsides:true, width:400, height:400,x:100 } );
			
			//SeaTurtle
			seaturtle = new SeaTurtle();
			seaturtle.material = currentMaterial
			seaturtle.scale(.5);
			seaturtle.rotationX = -45;
			
			currentObject = sphere;
			view.scene.addChild(currentObject);
		}
		
		private function onMaterialChangeEvent(e:Event):void
		{
			panel.setVisibility('togglePause', false);
			panel.setVisibility('lessSegments', false);
			panel.setVisibility('moreSegments', false);
			panel.setVisibility('lessExponent', false);
			panel.setVisibility('moreExponent', false);
			
			if (String(Object(currentMaterial).constructor) == '[class VideoMaterial]')
			{
				(currentMaterial as VideoMaterial).nc.close();
				(currentMaterial as VideoMaterial).netStream.close();
				(currentMaterial as VideoMaterial).video.clear();
			}
			
			if (currentObject != null)
			{
				view.scene.removeChild(currentObject);
				currentObject = null;
				currentMaterial = null;
			}
			
			if (e != null)
			{
				switch(e.type)
				{
					case 'WireframeMaterialEvent':
					currentMaterial = wireframe;
					currentObject = sphere;
					break;
					case 'WireColorMaterialEvent':
					currentMaterial = wirecolor;
					currentObject = cube;
					break;
					case 'ColorMaterialEvent':
					currentMaterial = color;
					currentObject = sphere;
					break;
					case 'EnviroColorMaterialEvent':
					currentMaterial = enviroColor;
					currentObject = seaturtle;
					break;
					case 'BitmapMaterialEvent':
					currentMaterial = bitmap;
					currentObject = seaturtle;
					break;
					case 'BitmapFileMaterialEvent':
					currentMaterial = bitmapFile;
					currentObject = plane;
					break;
					case 'EnviroBitmapMaterialEvent':
					currentMaterial = enviroBitmap;
					currentObject = seaturtle;
					break;
					case 'GlassMaterialEvent':
					var normalMap:Bitmap = new NormalMap();
					var waterMap:Bitmap = new WaterMap();
					currentObject = plane;
					currentMaterial = new GlassMaterial(normalMap.bitmapData, waterMap.bitmapData, currentObject, false, { smooth:true, exponent:0 } );
					panel.setVisibility('lessExponent', true);
					panel.setVisibility('moreExponent', true);
					break;
					case 'TransformBitmapMaterialEvent':
					panel.setVisibility('lessSegments', true);
					panel.setVisibility('moreSegments', true);
					currentMaterial = transformBitmap;
					currentObject = plane;
					break;
					case 'MovieMaterialEvent':
					currentMaterial = movie;
					currentObject = plane;
					break;
					case 'AnimatedBitmapMaterialEvent':
					currentMaterial = animatedBitmap;
					currentObject = plane;
					break;
					case 'VideoMaterialEvent':
					panel.setVisibility('togglePause', true);
					currentMaterial = new VideoMaterial( { file:'../../resources/flvs/test.flv' } );
					currentObject = plane;
					break;
					default:break;
				}
			}
			currentObject.material = currentMaterial;
			view.scene.addChild(currentObject);
			currentObject.position = new Vector3D(0, 0, 0);
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = panel.height + (stage.stageHeight - panel.height) *.5;
			panel.draw(stage.stageWidth, 50);
		}
		
		private function onEnterFrame(e:Event):void
		{
			currentObject.rotationY--;
			if (currentMaterial == transformBitmap) 
			{
				transformBitmap.offsetX += 10;
			}
			view.render();
		}
	}
}