package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import fl.core.UIComponent;
	import fl.controls.Button;
	import fl.controls.ComboBox;
	import fl.data.DataProvider;
	
	public class PrimitivesPanel extends Sprite
	{		
		public function PrimitivesPanel() 
		{
			var dp:DataProvider = new DataProvider();
			dp.addItem( { label: 'AbstractPrimitive', data: 'AbstractPrimitive' } );
			dp.addItem( { label: 'Arrow', data: 'Arrow' } );
			dp.addItem( { label: 'Cone', data: 'Cone' } );
			dp.addItem( { label: 'Cube', data: 'Cube' } );
			dp.addItem( { label: 'Cylinder', data: 'Cylinder' } );
			dp.addItem( { label: 'GeodesicSphere', data: 'GeodesicSphere' } );
			dp.addItem( { label: 'GridPlane', data: 'GridPlane' } );
			dp.addItem( { label: 'LineSegment', data: 'LineSegment' } );
			dp.addItem( { label: 'Plane', data: 'Plane' } );
			dp.addItem( { label: 'RegularPolygon', data: 'RegularPolygon' } );
			dp.addItem( { label: 'Sphere', data: 'Sphere' } );
			dp.addItem( { label: 'SeaTurtle', data: 'SeaTurtle' } );
			dp.addItem( { label: 'Torus', data: 'Torus' } );
			dp.addItem( { label: 'TorusKnot', data: 'TorusKnot' } );
			dp.addItem( { label: 'Triangle', data: 'Triangle' } );
			dp.addItem( { label: 'Trident', data: 'Trident' } );
			dp.addItem( { label: 'RoundedCube', data: 'RoundedCube' } );
			dp.addItem( { label: 'WireTorus', data: 'WireTorus' } );
			dp.addItem( { label: 'WireSphere', data: 'WireSphere' } );
			dp.addItem( { label: 'WireRegularPolygon', data: 'WireRegularPolygon' } );
			dp.addItem( { label: 'WirePlane', data: 'WirePlane' } );
			dp.addItem( { label: 'WireCylinder', data: 'WireCylinder' } );
			dp.addItem( { label: 'WireCube', data: 'WireCube' } );
			dp.addItem( { label: 'WireCone', data: 'WireCone' } );
			
			var primitiveSelect:ComboBox = new ComboBox();
			primitiveSelect.dataProvider = dp;
			primitiveSelect.width = 150;
			primitiveSelect.x = 15;
			primitiveSelect.y = 13;
			addChild(primitiveSelect);
			primitiveSelect.addEventListener(Event.CHANGE, primitiveChange);
		}
		
		private function primitiveChange(e:Event):void
		{
			dispatchEvent(new Event(e.target.value + 'Event'));
		}
		
		public function draw(_width:Number, _height:Number, _color:uint = 0xF1F1F1, _alpha:int = 1):void
		{
			graphics.clear();
			graphics.beginFill(_color,_alpha);
			graphics.drawRect(0, 0, _width, _height);
			graphics.endFill();
		}
	}
}