package
{
	import away3d.primitives.Sphere;
	import away3d.cameras.HoverCamera3D;
	import away3d.containers.View3D;
	import away3d.materials.BitmapFileMaterial;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.net.URLRequest;
	import flash.ui.Keyboard;
	import flash.geom.Vector3D;
	/**
	 * ...
	 * @author 
	 */
	public class SoundControlExample extends Sprite
	{
		private var view:View3D;
		private var music:Sound;
		private var musicChannel:SoundChannel;
		private var musicOn:Boolean = true;
		private var move:Boolean = false;
		private var camera:HoverCamera3D;
		private var lpa:Number;
		private var lta:Number;
		private var lmx:Number;
		private var lmy:Number;
		private var sph:Sphere;
		private var sphHelper:Sphere;
		private var len:int;
		private var power:Number = 10;
		private var ang:Number = 0;
		private var mod:Number = .05;
		private var _v3d:Vector3D = new Vector3D();
		private var v3d:Vector3D = new Vector3D();
		
		public function SoundControlExample() 
		{
			stage.quality = StageQuality.LOW;
			stage.align =  StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(Event.RESIZE, onResize);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
			//
			view = new View3D();
			addChild(view);
			sph = new Sphere();
			//sph.material = new BitmapFileMaterial('../../resources/bitmaps/specular.jpg');
			sph.segmentsH = 28;
			sph.segmentsW = 28;
			sphHelper = new Sphere();
			sphHelper.segmentsH = 28;
			sphHelper.segmentsW = 28;
			sphHelper.radius = 150;
			view.scene.addChild(sph);
			len = sphHelper.geometry.faces.length;
			/*
			 * Camera
			 */ 
			camera = new HoverCamera3D();
			camera.panAngle = 0;
			camera.tiltAngle = 0;
			view.camera = camera;
			/*
			 * Sound
			 */ 
            music = new Sound(new URLRequest("http://scfire-ntc-aa03.stream.aol.com:80/stream/1025" ));
            musicChannel = music.play();
			//
			onResize();
		}
		
		private function onKeyDown(e:KeyboardEvent):void
		{
			switch(e.keyCode)
			{
				case Keyboard.SPACE:
				if (musicOn) 
				{
					musicChannel.stop();
					musicOn = false;
					ang = mod = 0;
				}else
				{
					musicChannel = music.play();
					musicOn = true;
					mod = .05;
				}
				break;
			}
		}
		
		private function onMouseDown(e:MouseEvent):void
		{
			lpa = camera.panAngle;
			lta = camera.tiltAngle;
			lmx = stage.mouseX;
			lmy = stage.mouseY;
			move = true;
		}
		
		private function onMouseUp(e:MouseEvent):void
		{
			move = false;
		}
		
		private function onEnterFrame(e:Event):void
		{
            ang += mod;
            var ampL:Number = Math.sin(ang) * musicChannel.leftPeak * 4;
            var ampR:Number = Math.cos(ang) * musicChannel.rightPeak * 4;
			for ( var i:int = 0; i < len; ++i )
			{
				for ( var j:int = 0; j < 3; j++ )
				{
                    v3d.x = sphHelper.geometry.faces[i].vertices[j].x;
                    v3d.y = sphHelper.geometry.faces[i].vertices[j].y;
                    v3d.z = sphHelper.geometry.faces[i].vertices[j].z;
                    _v3d.x = v3d.x;
                    _v3d.y = v3d.y;
                    _v3d.z = v3d.z;
                    _v3d.normalize();
                    _v3d.x *= Math.sin( v3d.x * 0.5 ) * ampL * power;
                    _v3d.y *= Math.sin( v3d.x * 0.5 ) * ampL * power;
                    _v3d.z *= Math.sin( v3d.x * 0.5 ) * ampL * power;
                    v3d.x += _v3d.x;
                    v3d.y += _v3d.y;
                    v3d.z += _v3d.z;
					//
                    _v3d.x = v3d.x;
                    _v3d.y = v3d.y;
                    _v3d.z = v3d.z;
                    _v3d.normalize();
                    _v3d.x *= Math.cos( v3d.y * 0.5 ) * ampR * power;
                    _v3d.y *= Math.cos( v3d.y * 0.5 ) * ampR * power;
                    _v3d.z *= Math.cos( v3d.y * 0.5 ) * ampR * power;
                    v3d.x += _v3d.x;
                    v3d.y += _v3d.y;
                    v3d.z += _v3d.z;
					sph.geometry.faces[i].vertices[j].setValue(v3d.x, v3d.y, v3d.z);
					//sph.geometry.faces[i].vertices[j].x = v3d.x;
					//sph.geometry.faces[i].vertices[j].y = v3d.y;
					//sph.geometry.faces[i].vertices[j].z = v3d.z;
				}
			}
			if(move) 
			{
				camera.panAngle = .5 * (stage.mouseX - lmx) + lpa;
				camera.tiltAngle = .5 * (stage.mouseY - lmy) + lta;
			}
			camera.hover();
			view.render();
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;			
		}
	}
}