package
{
	import away3d.materials.BitmapFileMaterial;
	import away3d.containers.View3D;
	import away3d.primitives.Plane;
	import away3d.events.MouseEvent3D;
	import away3d.cameras.HoverCamera3D;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.ui.Keyboard;
	import flash.geom.Point;

	public class rpgExample extends Sprite
	{
		private var view:View3D;
		private var ground:Plane;
		private var player:Skeleton;
		private var camera:HoverCamera3D;
		
		private var _leftDown:Boolean = false;
		private var _rightDown:Boolean = false;
		private var _forwardDown:Boolean = false;
		private var _backwardDown:Boolean = false;
		
		public function rpgExample() 
		{
			stage.quality = StageQuality.LOW;
			stage.align =  StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(Event.RESIZE, onResize);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
			//
			view = new View3D();
			addChild(view);
			ground = new Plane();
			ground.material = new BitmapFileMaterial('../../resources/bitmaps/skybox/down.jpg');
			ground.segmentsH = ground.segmentsW = 10;
			ground.height = 1000;
			ground.width = 1000;
			ground.addOnMouseUp(onGroundClick);
			view.scene.addChild(ground);
			
			initPlayer();
			initCamera();
			onResize();
		}
		
		private function initCamera():void
		{
			camera = new HoverCamera3D();
			camera.target = player;
			camera.panAngle = -45;
			camera.tiltAngle = 20;
			camera.minTiltAngle = 0;
			camera.hover(true);
			view.camera = camera;
		}
		
		private function initPlayer():void
		{
			player = new Skeleton();
			player.x = player.z = 0;
			view.scene.addChild(player);
		}
		
		private function onGroundClick(e:MouseEvent3D):void
		{
			player.destination = new Point(e.sceneX, e.sceneZ);
		}
		
		private function onEnterFrame(e:Event):void
		{
			player.update();
			if (_forwardDown)
			{
				camera.tiltAngle += 2;
			}
			if (_backwardDown)
			{
				camera.tiltAngle -= 2;
			}
			if (_leftDown)
			{
				camera.panAngle += 2;
			}
			if (_rightDown)
			{
				camera.panAngle -= 2;
			}
			camera.hover();
			view.render();
		}
		
		private function onKeyDown(e:KeyboardEvent):void
		{
			switch(e.keyCode)
			{
				case Keyboard.LEFT:
				_leftDown = true;
				break;
				case Keyboard.RIGHT:
				_rightDown = true;
				break;
				case Keyboard.UP:
				_forwardDown = true;
				break;
				case Keyboard.DOWN:
				_backwardDown = true;
				break;
				default:break;
			}
		}
		
		private function onKeyUp(e:KeyboardEvent):void
		{
			switch(e.keyCode)
			{
				case Keyboard.LEFT:
				_leftDown = false;
				break;
				case Keyboard.RIGHT:
				_rightDown = false;
				break;
				case Keyboard.UP:
				_forwardDown = false;
				break;
				case Keyboard.DOWN:
				_backwardDown = false;
				break;
				default:break;
			}
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;			
		}
	}
}