package
{	
	import away3d.containers.View3D;
	import away3d.loaders.Loader3D;
	import away3d.events.Loader3DEvent;
	import away3d.primitives.Plane;
	import away3d.materials.BitmapFileMaterial;
	import away3d.core.base.Mesh;
	import away3d.loaders.data.AnimationData;
	import away3d.loaders.Md2;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;

	public class fppExample extends Sprite
	{
		private var view:View3D;
		private var pln:Plane;
		private var camera:FPP;
		private var player:Player;
		private var enemyAnim:AnimationData;
		private var modelLoader:Loader3D;
		
		public function fppExample() 
		{
			stage.quality = StageQuality.LOW;
			stage.align =  StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(Event.RESIZE, onResize);
			//
			view = new View3D();
			addChild(view);
			pln = new Plane();
			pln.material = new BitmapFileMaterial('../../resources/bitmaps/skybox/down.jpg');
			pln.y = -100;
			pln.segmentsH = pln.segmentsW = 10;
			pln.height = 1000;
			pln.width = 1000;
			view.scene.addChild(pln);
			/*
			 *  FPP i Player
			 */
			camera = new FPP(stage, { freeCamera:false,height:120 } );
			player = new Player(stage, camera);
			view.camera = camera;
			view.scene.addChild(player);
			/*
			 * Enemy
			 */
			modelLoader = Md2.load('../../resources/models/md2/hueteotl/TRIS.MD2');
			modelLoader.addOnSuccess(addEnemy);
			onResize();
		}
		
		private function addEnemy(e:Loader3DEvent = null):void
		{
			var mat:BitmapFileMaterial = new BitmapFileMaterial('../../resources/models/md2/hueteotl/hueteotl.jpg');
			var enemy:Mesh = modelLoader.handle as Mesh;
			enemy.scale(.08);
			enemy.material = mat;
			view.scene.addChild(enemy);
			enemyAnim = enemy.animationLibrary.getAnimation('stand');
			enemyAnim.animator.play();
		}
		
		private function onEnterFrame(e:Event):void
		{
			player.update();
			view.render();
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;			
		}
	}
}