package
{
	import flash.geom.Vector3D;
	import flash.events.Event;
	import flash.display.StageQuality;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	//
	import away3d.containers.View3D;
	import away3d.primitives.Cube;
	import away3d.core.utils.Cast;
	import away3d.materials.MovieMaterial;
	import away3d.primitives.data.CubeMaterialsData;
	import away3d.events.MouseEvent3D;
	/**
	 * ...
	 * @author 
	 */
	public class GraffitiExample extends Sprite
	{
		private var view:View3D;
		private var wall:Cube;
		private var cubeMaterials:CubeMaterialsData;
		private var drawingEnabled:Boolean = false;
		
		public function GraffitiExample() 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			stage.quality = StageQuality.LOW;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			removeEventListener(Event.ADDED_TO_STAGE, init);
			stage.addEventListener(Event.RESIZE, onResize);
			stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
			//
			view = new View3D();
			addChild(view);
			//
			cubeMaterials = new CubeMaterialsData();
			cubeMaterials.front = new MovieMaterial(new brickTexture(), { interactive:true } );
			cubeMaterials.back = new MovieMaterial(new brickTexture(), { interactive:true } );
			cubeMaterials.top = new MovieMaterial(new brickTexture(), { interactive:true } );
			cubeMaterials.bottom = new MovieMaterial(new brickTexture(), { interactive:true } );
			cubeMaterials.left = new MovieMaterial(new brickTexture(), { interactive:true } );
			cubeMaterials.right = new MovieMaterial(new brickTexture(), { interactive:true } );
			wall = new Cube( { width:1024, height:512, depth:50, cubeMaterials:cubeMaterials } );
			wall.addOnMouseDown(onMouseDown);
			wall.addOnMouseUp(onMouseUp);
			wall.addEventListener(MouseEvent3D.MOUSE_MOVE, onMouseMove);
			view.scene.addChild(wall);
			//
			onResize();
		}
		
		private function onMouseDown(e:MouseEvent3D):void
		{
			drawingEnabled = true;
		}
		
		private function onMouseUp(e:MouseEvent3D):void
		{
			drawingEnabled = false;
		}
		
		private function onMouseMove(e:MouseEvent3D):void
		{
			if (drawingEnabled)
			{
				var graff:Sprite = new Sprite();
				graff.graphics.beginFill(0xFF0000, .5);
				graff.graphics.drawCircle(e.uv.u * (e.material as MovieMaterial).movie.width, (e.material as MovieMaterial).movie.height - e.uv.v * (e.material as MovieMaterial).movie.height, 10);
				graff.graphics.endFill();
				(e.material as MovieMaterial).movie.addChild(graff);
			}
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;
		}
		
		private function onEnterFrame(e:Event):void
		{
			wall.rotationY -= .1;
			view.render();
		}
	}

}