package 
{
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix3D;
	import flash.geom.Vector3D;
	import flash.text.TextField;
	import flash.text.TextFormat;
	//
	import away3d.containers.View3D;
	import away3d.containers.ObjectContainer3D;
	import away3d.primitives.Cube;
	import away3d.primitives.Trident;
	//
	import com.greensock.TimelineMax;
	import com.greensock.TweenMax;
	/**
	 * ...
	 * @author 
	 */
	public class MoveRotateScaleExample extends Sprite 
	{
		private var view:View3D;
		private var obj:ObjectContainer3D;
		private var cube:Cube;
		private var trident:Trident;
		private var panel:Sprite;
		private var label:TextField;
		private var anims:TimelineMax;
		
		public function MoveRotateScaleExample():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			stage.quality = StageQuality.LOW;
			stage.align =  StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(Event.RESIZE, onResize);
			
			view = new View3D();
			addChild(view);
			
			panel = new Sprite();
			addChild(panel);
			label = new TextField();
			label.defaultTextFormat = new TextFormat("_sans",10);
			panel.addChild(label);
			cube = new Cube( { width:50, height:50, depth:50 } );
			trident = new Trident(100,true);
			obj = new ObjectContainer3D();
			obj.addChild(trident);
			obj.addChild(cube);
			view.scene.addChild(obj);
			
			anims = new TimelineMax( { repeat: -1, repeatDelay:2 } );
			anims.append(TweenMax.to(obj, 1, 
			{
				x: -100,
				y: 100,
				z: 200,
				onStart:function()
				{
					label.text = "Użycie parametrów: x, y, z";
				}
			}));
			anims.append(TweenMax.to(obj, 1, 
			{
				delay:2,
				onStart:function()
				{
					label.text = "Użycie parametru position";
					obj.position = new Vector3D(-300,-100,300)
				}
			}));
			anims.append(TweenMax.to(obj, 1, 
			{
				delay:2,
				onStart:function() 
				{ 
					label.text = "Użycie metody translate()";
				},
				onUpdate:function()
				{ 
					obj.translate(new Vector3D(1, 1, 0), 10);
				}
			}));
			anims.append(TweenMax.to(obj, 1, 
			{
				delay:2,
				onStart:function() 
				{ 
					label.text = "Użycie metody moveTo()";
					obj.moveTo(0, 0, 0);
				}
			}));
			anims.append(TweenMax.to(obj, 1, 
			{
				delay:2,
				onStart:function() 
				{ 
					label.text = "Użycie metody moveForward()";
				},
				onUpdate:function()
				{ 
					obj.moveForward(10);
				}
			}));
			anims.append(TweenMax.to(obj, 1, 
			{
				delay:2,
				onStart:function() 
				{ 
					label.text = "Użycie metody moveBackward()";
				},
				onUpdate:function()
				{ 
					obj.moveBackward(10);
				}
			}));
			anims.append(TweenMax.to(obj, 1, 
			{
				delay:2,
				onStart:function() 
				{ 
					label.text = "Użycie metody moveUp()";
				},
				onUpdate:function()
				{ 
					obj.moveUp(10);
				}
			}));
			anims.append(TweenMax.to(obj, 1, 
			{
				delay:2,
				onStart:function() 
				{ 
					label.text = "Użycie metody moveDown()";
				},
				onUpdate:function()
				{ 
					obj.moveDown(10);
				}
			}));
			anims.append(TweenMax.to(obj, 1, 
			{
				delay:2,
				onStart:function() 
				{ 
					label.text = "Użycie metody moveLeft()";
				},
				onUpdate:function()
				{ 
					obj.moveLeft(10);
				}
			}));
			anims.append(TweenMax.to(obj, 1, 
			{
				delay:2,
				onStart:function() 
				{ 
					label.text = "Użycie metody moveRight()";
				},
				onUpdate:function()
				{ 
					obj.moveRight(10);
				}
			}));
			anims.append(TweenMax.to(obj, 1, 
			{
				delay:2,
				rotationY:90,
				onStart:function()
				{
					label.text = "Użycie parametru pivotPoint";
					obj.pivotPoint = new Vector3D(100,0,200);
				}
			}));
			anims.append(TweenMax.to(obj, 1, 
			{
				delay:2,
				rotationX:90,
				rotationY:90,
				rotationZ:90,
				onStart:function()
				{
					label.text = "Użycie parametrów: rotationX, rotationY, rotationZ";
					obj.pivotPoint = new Vector3D(0,0,0);
				}
			}));
			anims.append(TweenMax.to(obj, 1, 
			{
				delay:2,
				onStart:function()
				{
					label.text = "Użycie metody: rotateTo()";
					obj.rotateTo(0, 0, 0);
				}
			}));
			anims.append(TweenMax.to(obj, 1, 
			{
				delay:2,
				onStart:function() 
				{ 
					label.text = "Użycie metody: rotate()";
				},
				onUpdate:function()
				{ 
					obj.rotate(new Vector3D(0,1,0),10);
				}
			}));
			anims.append(TweenMax.to(obj, 1, 
			{
				delay:2,
				onStart:function()
				{
					label.text = "Użycie metody: lookAt()";
					obj.lookAt(new Vector3D(100,100,0));
				}
			}));
			anims.append(TweenMax.to(obj, 1, 
			{
				delay:2,
				onStart:function() 
				{ 
					label.text = "Użycie metody: pitch()";
				},
				onUpdate:function()
				{ 
					obj.pitch(10);
				}
			}));
			anims.append(TweenMax.to(obj, 1, 
			{
				delay:2,
				onStart:function() 
				{ 
					label.text = "Użycie metody: roll()";
				},
				onUpdate:function()
				{ 
					obj.roll(10);
				}
			}));
			anims.append(TweenMax.to(obj, 1, 
			{
				delay:2,
				onStart:function() 
				{ 
					label.text = "Użycie metody: yaw()";
				},
				onUpdate:function()
				{ 
					obj.yaw(10);
				}
			}));
			anims.append(TweenMax.to(obj, 1, 
			{
				delay:2,
				scaleX:3,
				scaleY:2,
				scaleZ:4,
				onStart:function()
				{
					label.text = "Użycie parametry: scaleX, scaleY, scaleZ";
				}
			}));
			anims.append(TweenMax.to(obj, 1, 
			{
				delay:2,
				onStart:function()
				{
					label.text = "Użycie metody: scale()";
					obj.scale(.5);
				}
			}));
			anims.append(TweenMax.to(obj, 1, 
			{
				delay:2,
				rotationX:0,
				rotationY:0,
				rotationZ:0,
				x:0,
				y:0,
				z:0,
				onStart:function()
				{
					obj.scale(1);
					label.text = "";
				}
			}));
			onResize();
		}
		
		private function onEnterFrame(e:Event):void
		{
			view.render();
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;
			//
			panel.graphics.beginFill(0xf1f1f1);
			panel.graphics.drawRect(0, 0, stage.stageWidth, 40);
            panel.graphics.endFill();
			label.width = panel.width;
			label.height = panel.height;
		}
	}
}