package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import fl.core.UIComponent;
	import fl.controls.Label;
	import fl.controls.Button;
	import fl.controls.ComboBox;
	import fl.data.DataProvider;
	
	public class MaterialsPanel extends Sprite
	{		
		public function MaterialsPanel() 
		{
			var materialLabel:Label = new Label();
            materialLabel.text = 'Materiał:';
			materialLabel.x = 15;
			materialLabel.y = 15;
			materialLabel.width = 70;
			addChild(materialLabel);
			
			var dp:DataProvider = new DataProvider();
			dp.addItem( { label: 'WireframeMaterial', data: 'WireframeMaterial' } );
			dp.addItem( { label: 'WireColorMaterial', data: 'WireColorMaterial' } );
			dp.addItem( { label: 'ColorMaterial', data: 'ColorMaterial' } );
			dp.addItem( { label: 'EnviroColorMaterial', data: 'EnviroColorMaterial' } );
			dp.addItem( { label: 'BitmapMaterial', data: 'BitmapMaterial' } );
			dp.addItem( { label: 'BitmapFileMaterial', data: 'BitmapFileMaterial' } );
			dp.addItem( { label: 'EnviroBitmapMaterial', data: 'EnviroBitmapMaterial' } );
			dp.addItem( { label: 'GlassMaterial', data: 'GlassMaterial' } );
			dp.addItem( { label: 'TransformBitmapMaterial', data: 'TransformBitmapMaterial' } );
			dp.addItem( { label: 'MovieMaterial', data: 'MovieMaterial' } );
			dp.addItem( { label: 'AnimatedBitmapMaterial', data: 'AnimatedBitmapMaterial' } );
			dp.addItem( { label: 'VideoMaterial', data: 'VideoMaterial' } );
			
			var materialSelect:ComboBox = new ComboBox();
			materialSelect.name = 'materialSelect';
			materialSelect.dataProvider = dp;
			materialSelect.width = 150;
			materialSelect.x = 70;
			materialSelect.y = 10;
			addChild(materialSelect);
			materialSelect.addEventListener(Event.CHANGE, materialChange);
			
			var togglePauseButton:Button = new Button();
			togglePauseButton.name = "togglePause";
			togglePauseButton.label = "Włącz/Wyłącz";
			togglePauseButton.x = 220;
			togglePauseButton.y = 10;
			togglePauseButton.width = 100;
			togglePauseButton.visible = false;
			addChild(togglePauseButton);
			togglePauseButton.addEventListener(MouseEvent.CLICK, buttonClick);
			
			var lessSegmentsButton:Button = new Button();
			lessSegmentsButton.name = "lessSegments";
			lessSegmentsButton.label = "-";
			lessSegmentsButton.x = 220;
			lessSegmentsButton.y = 10;
			lessSegmentsButton.width = 30;
			lessSegmentsButton.visible = false;
			addChild(lessSegmentsButton);
			lessSegmentsButton.addEventListener(MouseEvent.CLICK, buttonClick);
			
			var moreSegmentsButton:Button = new Button();
			moreSegmentsButton.name = "moreSegments";
			moreSegmentsButton.label = "+";
			moreSegmentsButton.x = 270;
			moreSegmentsButton.y = 10;
			moreSegmentsButton.width = 30;
			moreSegmentsButton.visible = false;
			addChild(moreSegmentsButton);
			moreSegmentsButton.addEventListener(MouseEvent.CLICK, buttonClick);
			
			var lessExponentButton:Button = new Button();
			lessExponentButton.name = "lessExponent";
			lessExponentButton.label = "-";
			lessExponentButton.x = 220;
			lessExponentButton.y = 10;
			lessExponentButton.width = 30;
			lessExponentButton.visible = false;
			addChild(lessExponentButton);
			lessExponentButton.addEventListener(MouseEvent.CLICK, buttonClick);
			
			var moreExponentButton:Button = new Button();
			moreExponentButton.name = "moreExponent";
			moreExponentButton.label = "+";
			moreExponentButton.x = 270;
			moreExponentButton.y = 10;
			moreExponentButton.width = 30;
			moreExponentButton.visible = false;
			addChild(moreExponentButton);
			moreExponentButton.addEventListener(MouseEvent.CLICK, buttonClick);
		}
		
		private function materialChange(e:Event):void
		{
			dispatchEvent(new Event(e.target.value + 'Event'));
		}
		
		private function buttonClick(e:MouseEvent):void
		{
			dispatchEvent(new Event(e.target.name + 'Event'));
		}
		
		public function setVisibility(objectName:String,val:Boolean):void
		{
			if (getChildByName(objectName) is UIComponent) 
			{
				(getChildByName(objectName) as UIComponent).visible = val;
			}
		}
		
		public function setLabel(labelName:String,val:String):void
		{
			if (getChildByName(labelName) is Button) 
			{
				(getChildByName(labelName) as Button).label = val;
			}
		}
		
		public function draw(_width:Number, _height:Number, _color:uint = 0xF1F1F1, _alpha:int = 1):void
		{
			graphics.clear();
			graphics.beginFill(_color,_alpha);
			graphics.drawRect(0, 0, _width, _height);
			graphics.endFill();
		}
	}
}