package  
{
	import away3d.containers.View3D;
	import away3d.core.base.Vertex;
	import away3d.primitives.*;
	import away3d.containers.ObjectContainer3D;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.*;
	import flash.geom.Vector3D;
	
	public class primitivesExample extends Sprite
	{
		private var panel:PrimitivesPanel;
		
		private var view:View3D;
		private var container:ObjectContainer3D;
		private var arrowhead:Arrowhead;
		private var arrow:Arrow;
		private var cone:Cone;
		private var cone2:Cone;
		private var cube:Cube;
		private var cylinder:Cylinder;
		private var geodesicSphere:GeodesicSphere;
		private var grid:GridPlane;
		private var line:LineSegment;
		private var plane:Plane;
		private var polygon:RegularPolygon;
		private var roundedCube:RoundedCube;
		private var sphere:Sphere;
		private var turtle:SeaTurtle;
		private var torus:Torus;
		private var torusKnot:TorusKnot;
		private var triangle:Triangle;
		private var trident:Trident;
		private var wireCone:WireCone;
		private var wireCube:WireCube;
		private var wireCylinder:WireCylinder;
		private var wirePlane:WirePlane;
		private var wirePolygon:WireRegularPolygon;
		private var wireSphere:WireSphere;
		private var wireTorus:WireTorus;
		
		public function primitivesExample() 
		{
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			view = new View3D();
			view.camera.position = new Vector3D(0, 600, -1000);
			view.camera.lookAt(new Vector3D(0, 0, 0));
			addChild(view);
			initPrimitives();
			addPanel();
			onResize();
			stage.addEventListener(Event.RESIZE, onResize);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function addPanel():void
		{
			panel = new PrimitivesPanel();
			addChild(panel);
			panel.addEventListener('ArrowEvent', primitiveChange);
			panel.addEventListener('ConeEvent', primitiveChange);
			panel.addEventListener('CubeEvent', primitiveChange);
			panel.addEventListener('CylinderEvent', primitiveChange);
			panel.addEventListener('GeodesicSphereEvent', primitiveChange);
			panel.addEventListener('GridPlaneEvent', primitiveChange);
			panel.addEventListener('LineSegmentEvent', primitiveChange);
			panel.addEventListener('PlaneEvent', primitiveChange);
			panel.addEventListener('RegularPolygonEvent', primitiveChange);
			panel.addEventListener('SphereEvent', primitiveChange);
			panel.addEventListener('SeaTurtleEvent', primitiveChange);
			panel.addEventListener('TorusEvent', primitiveChange);
			panel.addEventListener('TorusKnotEvent', primitiveChange);
			panel.addEventListener('TriangleEvent', primitiveChange);
			panel.addEventListener('TridentEvent', primitiveChange);
			panel.addEventListener('RoundedCubeEvent', primitiveChange);
			panel.addEventListener('WireTorusEvent', primitiveChange);
			panel.addEventListener('WireSphereEvent', primitiveChange);
			panel.addEventListener('WireRegularPolygonEvent', primitiveChange);
			panel.addEventListener('WirePlaneEvent', primitiveChange);
			panel.addEventListener('WireCylinderEvent', primitiveChange);
			panel.addEventListener('WireCubeEvent', primitiveChange);
			panel.addEventListener('WireConeEvent', primitiveChange);
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = panel.height + (stage.stageHeight - panel.height) *.5;
			panel.draw(stage.stageWidth, 50);
		}
		
		private function onEnterFrame(e:Event):void
		{
			container.rotationY++;
			view.render();
		}
		
		private function initPrimitives():void
		{
			/*
			 * ObjectContainer3D
			 */ 
			container = new ObjectContainer3D();
			view.scene.addChild(container);
			/*
			 * Arrowhead
			 */
			arrowhead = new Arrowhead();
			arrowhead.y = -150;
			arrowhead.height = 300;
			arrowhead.width = 300;
			arrowhead.bothsides = true;
			arrowhead.sides = 3;
			/*
			 * Arrow
			 */
			arrow = new Arrow();
			arrow.height = 400;
			arrow.width = 400;
			arrow.tailLength = 250;
			arrow.tailWidth = 100;
			arrow.thickness = 100;
			arrow.bothsides = true;
			arrow.rotationX = -90;
			arrow.y = 150;
			/*
			 * Cone
			 */ 
			cone = new Cone();
			cone.radius = 150;
			cone.bothsides = true;
			cone.height = 300;
			cone.x = -150;
			cone2 = new Cone();
			cone2.radius = 150;
			cone2.x = 150;
			cone2.bothsides = true;
			cone2.segmentsH = 2;
			cone2.height = 300;
			(cone2.vertices[cone2.vertices.length - 1] as Vertex).y = 0;
			/*
			 * Cube
			 */
			cube = new Cube();
			cube.width = 250;
			cube.height = 250;
			cube.depth = 250;
			/*
			 * Cylinder
			 */ 
			cylinder = new Cylinder();
			cylinder.radius = 150;
			cylinder.height = 250;
			/*
			 * GeodesicSphere
			 */ 
			geodesicSphere = new GeodesicSphere();
			geodesicSphere.radius = 200;
			/*
			 * GridPlane
			 */ 
			grid = new GridPlane();
			grid.width = 450;
			grid.height = 450;
			grid.segmentsH = 10;
			grid.segmentsW = 10;
			/*
			 * LineSegment
			 */ 
			line = new LineSegment();
			/*
			 * Plane
			 */ 
			plane = new Plane();
			plane.width = 350;
			plane.height = 350;
			plane.yUp = false;
			plane.bothsides = true;
			/*
			 * RegularPolygon
			 */ 
			polygon = new RegularPolygon();
			polygon.radius = 200;
			polygon.yUp = false;
			polygon.bothsides = true;
			/*
			 * RoundedCube
			 */ 
			roundedCube = new RoundedCube();
			roundedCube.width = 250;
			roundedCube.height = 250;
			roundedCube.depth = 250;
			/*
			 * Sphere
			 */ 
			sphere = new Sphere(); 
			sphere.radius = 200;
			/*
			 * SeaTurtle
			 */ 
			turtle = new SeaTurtle();
			turtle.rotationX = 45;
			turtle.scale(.75);
			/*
			 * Torus
			 */ 
			torus = new Torus();
			torus.tube = 60;
			torus.radius = 200;
			/*
			 * TorusKnot
			 */ 
			torusKnot = new TorusKnot(); 
			torusKnot.p = 2; 
			torusKnot.q = 3;
			torusKnot.segmentsT = 8;
			torusKnot.segmentsR = 64;
			torusKnot.tube = 20;
			torusKnot.radius = 150;
			torusKnot.rotationX = 90;
			/*
			 * Triangle
			 */ 
			triangle = new Triangle();
			triangle.bothsides = true;
			triangle.a = new Vertex(0, 200, 0);
			triangle.b = new Vertex(200, -150, 0);
			triangle.c = new Vertex(-200, -150, 0);
			/*
			 * Trident
			 */ 
			trident = new Trident(250, true);
			/*
			 * WireCone
			 */
			wireCone = new WireCone();
			wireCone.radius = 150;
			wireCone.height = 300;
			/*
			 * WireCube
			 */ 
			wireCube = new WireCube();
			wireCube.width = 250;
			wireCube.height = 250;
			wireCube.depth = 250;
			/*
			 * WireCylinder
			 */ 
			wireCylinder = new WireCylinder();
			wireCylinder.radius = 150;
			wireCylinder.height = 250;
			/*
			 * WirePlane
			 */ 
			wirePlane = new WirePlane();
			wirePlane.width = 350;
			wirePlane.height = 350;
			wirePlane.segmentsH = 4;
			wirePlane.segmentsW = 4;
			wirePlane.yUp = false;
			/*
			 * WireRegularPolygon
			 */ 
			wirePolygon = new WireRegularPolygon(); 
			wirePolygon.radius = 200;
			wirePolygon.yUp = false;
			/*
			 * WireSphere
			 */ 
			wireSphere = new WireSphere(); 
			wireSphere.radius = 200;
			/*
			 * WireTorus
			 */ 
			wireTorus = new WireTorus();
			wireTorus.tube = 60;
			wireTorus.radius = 200;
			//
			container.addChild(arrowhead);
		}
		
		private function primitiveChange(e:Event = null):void
		{
			while(container.children.length > 0) container.removeChild(container.children[0]);
			if (e != null)
			{
				switch(e.type)
				{
					case 'AbstractPrimitiveEvent': 
					container.addChild(arrowhead); 
					break;
					case 'ArrowEvent': 
					container.addChild(arrow);
					break;
					case 'ConeEvent': 
					container.addChild(cone);
					container.addChild(cone2);
					break;
					case 'CubeEvent': 
					container.addChild(cube);
					break;
					case 'CylinderEvent': 
					container.addChild(cylinder);
					break;
					case 'GeodesicSphereEvent': 
					container.addChild(geodesicSphere);
					break;
					case 'GridPlaneEvent': 
					container.addChild(grid);
					break;
					case 'LineSegmentEvent': 
					container.addChild(line);
					break;
					case 'PlaneEvent': 
					container.addChild(plane);
					break;
					case 'RegularPolygonEvent': 
					container.addChild(polygon);
					break;
					case 'SphereEvent': 
					container.addChild(sphere);
					break;
					case 'SeaTurtleEvent': 
					container.addChild(turtle);
					break;
					case 'TorusEvent': 
					container.addChild(torus);
					break;
					case 'TorusKnotEvent': 
					container.addChild(torusKnot);
					break;
					case 'TriangleEvent': 
					container.addChild(triangle);
					break;
					case 'TridentEvent':
					container.addChild(trident);
					break;
					case 'RoundedCubeEvent':
					container.addChild(roundedCube);
					break;
					case 'WireTorusEvent':
					container.addChild(wireTorus);
					break;
					case 'WireSphereEvent':
					container.addChild(wireSphere);
					break;
					case 'WireRegularPolygonEvent':
					container.addChild(wirePolygon);
					break;
					case 'WirePlaneEvent':
					container.addChild(wirePlane);
					break;
					case 'WireCylinderEvent':
					container.addChild(wireCylinder);
					break;
					case 'WireCubeEvent':
					container.addChild(wireCube);
					break;
					case 'WireConeEvent':
					container.addChild(wireCone);
					break;
					default:break;
				}
			}
		}
	}
}