package
{
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Vector3D;
	
	import away3d.containers.View3D;
	import away3d.tools.Weld;
	import away3d.loaders.Loader3D;
	import away3d.loaders.Max3DS;
	import away3d.events.Loader3DEvent;
	import away3d.core.base.Mesh;
	import away3d.materials.BitmapFileMaterial;
	
	public class WeldExample extends Sprite
	{
		private var view:View3D;
		private var modelLoader:Loader3D;
		private var mdl:Mesh;
		
		public function WeldExample()
		{
			stage.quality = StageQuality.LOW;
			stage.align =  StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.addEventListener(Event.RESIZE, onResize);
			
			view = new View3D();
			addChild(view);
			//
			modelLoader = Max3DS.load('../../resources/models/max3ds/spaceship/spaceship.3DS');
			modelLoader.addOnSuccess(onModelLoaded);
			//
			onResize();
		}
		
		private function onModelLoaded(e:Loader3DEvent):void
		{
			mdl = modelLoader.handle as Mesh;
			mdl.position = new Vector3D(0, 0, 0);
			mdl.scale(16);
			view.scene.addChild(mdl);
			//
			var weld:Weld = new Weld();
			weld.doUVs = true;
			weld.apply(mdl);
			trace("Usunięto", weld.countvertices, "zbędnych wierzchołków i", weld.countuvs, "współrzędnych UV");
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(e:Event):void
		{
			mdl.rotationY--;
			view.render();
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;			
		}
	}
}