﻿package away3d.materials
{
	import away3d.arcane;
	import away3d.events.*;
	
	import flash.display.*;
	import flash.events.*;
	import flash.net.*;
	import flash.system.LoaderContext;
    			
	use namespace arcane;
	
	 /**
	 * Dispatched when the material completes a file load successfully.
	 * 
	 * @eventType away3d.events.MaterialEvent
	 */
	[Event(name="loadSuccess",type="away3d.events.MaterialEvent")]
    			
	 /**
	 * Dispatched when the material fails to load a file.
	 * 
	 * @eventType away3d.events.MaterialEvent
	 */
	[Event(name="loadError",type="away3d.events.MaterialEvent")]
    			
	 /**
	 * Dispatched every frame the material is loading.
	 * 
	 * @eventType away3d.events.MaterialEvent
	 */
	[Event(name="loadProgress",type="away3d.events.MaterialEvent")]
	
    /**
    * Bitmap material that loads it's texture from an external bitmapasset file.
    */
    public class BitmapFileMaterial extends TransformBitmapMaterial
    {
		private var _loader:Loader;
		private var _materialloaderror:MaterialEvent;
		private var _materialloadprogress:MaterialEvent;
		private var _materialloadsuccess:MaterialEvent;
		
		private function onError(e:IOErrorEvent):void
		{			
			if (!_materialloaderror)
				_materialloaderror = new MaterialEvent(MaterialEvent.LOAD_ERROR, this);
			
            dispatchEvent(_materialloaderror);
		}
		
		private function onProgress(e:ProgressEvent):void
		{
			if (!_materialloadprogress)
				_materialloadprogress = new MaterialEvent(MaterialEvent.LOAD_PROGRESS, this);
			
            dispatchEvent(_materialloadprogress);
		}
		
		private function onComplete(e:Event):void
		{
			bitmap = Bitmap(_loader.content).bitmapData;
			
			if (!_materialloadsuccess)
				_materialloadsuccess = new MaterialEvent(MaterialEvent.LOAD_SUCCESS, this);
			
            dispatchEvent(_materialloadsuccess);
		}
    	
    	public function get loader():Loader
    	{
    		return _loader;
    	}
    	
		/**
		 * Creates a new <code>BitmapFileMaterial</code> object.
		 *
		 * @param	url					The location of the bitmapasset to load.
		 * @param	init	[optional]	An initialisation object for specifying default instance properties.
		 */
		public function BitmapFileMaterial( url :String="", init:Object = null)
        {
            super(new BitmapData(100,100), init);
            var checkPolicyFile:Boolean = ini.getBoolean("checkPolicyFile", false);
			url = (url.substring(0,7) == "/file:/")? url.substring(7,url.length) : url;
			
			if(url.substring(0,2) == "//"){
				url = url.toLowerCase();
				var charvar:int = 97;
				while(charvar<123){
					if(url.charCodeAt(2) == charvar){
						url = (url.substring(0,5) == "//"+String.fromCharCode(charvar)+":/")? url.substring(2,url.length) : url;
						break;
					}
					charvar++; 
				}
			}
			
			if(url.charCodeAt(url.length-1) < 49)
				url = url.substring(0, url.length-1);
				
			_loader = new Loader();
			_loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onError);
            _loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, onProgress);
			_loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
			var context:LoaderContext = new LoaderContext();
			context.checkPolicyFile = checkPolicyFile;
			_loader.load(new URLRequest(unescape(url)), context);
        }
        
		/**
		 * Default method for adding a loadSuccess event listener
		 * 
		 * @param	listener		The listener function
		 */
        public function addOnLoadSuccess(listener:Function):void
        {
            addEventListener(MaterialEvent.LOAD_SUCCESS, listener, false, 0, true);
        }
		
		/**
		 * Default method for removing a loadSuccess event listener
		 * 
		 * @param	listener		The listener function
		 */
        public function removeOnLoadSuccess(listener:Function):void
        {
            removeEventListener(MaterialEvent.LOAD_SUCCESS, listener, false);
        }
		
		/**
		 * Default method for adding a loadProgress event listener
		 * 
		 * @param	listener		The listener function
		 */
        public function addOnLoadProgress(listener:Function):void
        {
            addEventListener(MaterialEvent.LOAD_PROGRESS, listener, false, 0, true);
        }
		
		/**
		 * Default method for removing a loadProgress event listener
		 * 
		 * @param	listener		The listener function
		 */
        public function removeOnLoadProgress(listener:Function):void
        {
            removeEventListener(MaterialEvent.LOAD_PROGRESS, listener, false);
        }	
        	
		/**
		 * Default method for adding a loadError event listener
		 * 
		 * @param	listener		The listener function
		 */
        public function addOnLoadError(listener:Function):void
        {
            addEventListener(MaterialEvent.LOAD_ERROR, listener, false, 0, true);
        }
		
		/**
		 * Default method for removing a loadError event listener
		 * 
		 * @param	listener		The listener function
		 */
        public function removeOnLoadError(listener:Function):void
        {
            removeEventListener(MaterialEvent.LOAD_ERROR, listener, false);
        }
    }
}