﻿package away3d.exporters
{
	import away3d.arcane;
	import away3d.containers.*;
	import away3d.core.base.*;
	import away3d.loaders.data.*;
	import away3d.materials.*;
	import away3d.primitives.*;
	import away3d.events.*;
	
	import flash.events.*;
	import flash.geom.*;
	import flash.utils.*;
	
	use namespace arcane;
	
	public class AS3Exporter extends EventDispatcher{
		
		private var useMesh:Boolean;
		private var isAnim:Boolean;
		private var asString:String;
		private var containerString:String;
		private var materialString:String;
		private var geoString:String;
		private var meshString:String;
		private var gcount:int;
		private var mcount:int;
		private var objcount:int;
		private var geocount:int;
		private var geonums:Dictionary;
		private var facenums:Dictionary;
		private var indV:int;
		private var indVt:int;
		private var indF:int;
		private var geos:Array;		
		private var p1:RegExp = new RegExp("/0.0000/","g");
		
		private var aTypes:Array =  [Plane, Sphere, Cube, Cone, Cylinder, RegularPolygon, Torus, GeodesicSphere, Skybox, Skybox6, LineSegment, GridPlane, WireTorus, WireRegularPolygon, WireCone, WireCube, WireCylinder, WirePlane, WireSphere]; 
		
		private  function reset():void
		{
			containerString = "";
			materialString = "";
			geoString = "";
			meshString = "";
			indV = indVt = indF = gcount = mcount = objcount = geocount = 0;
			geonums = new Dictionary(true);
			facenums = new Dictionary(true);
			geos= [];	
		}
	
		private  function write(object3d:Object3D, containerid:int = -1):void
		{
			var mat:String = "null"; 
			var nameinsert:String = (object3d.name == null)? "" : "name:\""+object3d.name+"\", ";
			var mesh:Mesh = Mesh(object3d);
			var bothsidesinsert:String = (mesh.bothsides)? "bothsides:true, " : "";
			var type:String = "";
			for( var i:int = 0; i<aTypes.length ; ++i)
			{
				if(object3d is aTypes[i]){
					type = (""+aTypes[i]);
					type = type.substring(7, type.length-1);
					if(i>9){
						var linemat:WireframeMaterial = mesh.material  as WireframeMaterial;
						var wirematinsert:String = " material: new WireframeMaterial(0x"+linemat.wireColor.toString(16).toUpperCase()+", {thickness:"+linemat.thickness+"*_scale})";
					}
					break;
				}
			}
			
			var xpos:String = (object3d.x == 0)? "0" : object3d.x+"*_scale";
			var ypos:String = (object3d.y == 0)? "0" : object3d.y+"*_scale";
			var zpos:String = (object3d.z == 0)? "0" : object3d.z+"*_scale";
			
			if(type != ""){
					var objname:String = ""+type.toLowerCase()+objcount;
					var constructinsert:String = "\n\t\t\tvar "+objname+":"+type+" = new "+type+"(";
					
					switch(type){
						case "Sphere":
							meshString += constructinsert+"{"+nameinsert+bothsidesinsert+"material:"+mat+", segmentsH:"+(object3d as aTypes[i]).segmentsH+", segmentsW:"+(object3d as aTypes[i]).segmentsW+", radius:"+(object3d as aTypes[i]).radius+"*_scale});";
							break;

						case "Plane":
							meshString += constructinsert+"{"+nameinsert+bothsidesinsert+"material:"+mat+", segmentsH:"+(object3d as aTypes[i]).segmentsH+", segmentsW:"+(object3d as aTypes[i]).segmentsW+", width:"+(object3d as aTypes[i]).width+"*_scale, height:"+(object3d as aTypes[i]).height+"*_scale});";
							break;

						case "Cone":
							meshString += constructinsert+"{"+nameinsert+bothsidesinsert+"material:"+mat+", segmentsH:"+(object3d as aTypes[i]).segmentsH+", segmentsW:"+(object3d as aTypes[i]).segmentsW+", radius:"+(object3d as aTypes[i]).radius+"*_scale, height:"+(object3d as aTypes[i]).height+", openEnded:"+(object3d as aTypes[i]).openEnded+"});";
							break;

						case "Cube":
							meshString += constructinsert+"{"+nameinsert+bothsidesinsert+"material:"+mat+", height:"+(object3d as aTypes[i]).height+"*_scale, depth:"+(object3d as aTypes[i]).depth+"*_scale, width:"+(object3d as aTypes[i]).width+"*_scale});";
							break;

						case "Cylinder":
							meshString += constructinsert+"{"+nameinsert+bothsidesinsert+"material:"+mat+", segmentsH:"+(object3d as aTypes[i]).segmentsH+", segmentsW:"+(object3d as aTypes[i]).segmentsW+", radius:"+(object3d as aTypes[i]).radius+"*_scale, height:"+(object3d as aTypes[i]).height+"*_scale, openEnded:"+(object3d as aTypes[i]).openEnded+"});";
							break;

						case "RegularPolygon":
							meshString += constructinsert+"{"+nameinsert+bothsidesinsert+"material:"+mat+", radius:"+(object3d as aTypes[i]).radius+"*_scale, sides:"+(object3d as aTypes[i]).sides+", yUp:"+(object3d as aTypes[i]).yUp+"});";
							break;

						case "Torus":
							meshString += constructinsert+"{"+nameinsert+bothsidesinsert+"material:"+mat+", segmentsR:"+(object3d as aTypes[i]).segmentsR+", segmentsT:"+(object3d as aTypes[i]).segmentsT+", radius:"+(object3d as aTypes[i]).radius+"*_scale, tube:"+(object3d as aTypes[i]).tube+"*_scale});";
							break;

						case "LineSegment":
							var v0:Vertex = (object3d as aTypes[i]).start;
							var v1:Vertex = (object3d as aTypes[i]).end;
							meshString += constructinsert+"{"+nameinsert+wirematinsert+"});\n\t\t\t"+objname+".start = new Vertex("+v0.x+"*_scale,"+v0.y+"*_scale,"+v0.z+"*_scale);\n\t\t\t"+objname+".end = new Vertex("+v1.x+"*_scale,"+v1.y+"*_scale,"+v1.z+"*_scale);";
							break;

						case "WireTorus":
							meshString += constructinsert+"{"+nameinsert+wirematinsert+", radius:"+(object3d as aTypes[i]).radius+"*_scale, tube:"+(object3d as aTypes[i]).tube+", segmentsR:"+(object3d as aTypes[i]).segmentsR+", segmentsT:"+(object3d as aTypes[i]).segmentsT+"});";
							break;

						case "WireRegularPolygon":
							meshString += constructinsert+"{"+nameinsert+wirematinsert+", radius:"+(object3d as aTypes[i]).radius+"*_scale, sides:"+(object3d as aTypes[i]).sides+"});";
							break;

						case "WireCone":
							meshString += constructinsert+"{"+nameinsert+wirematinsert+", radius:"+(object3d as aTypes[i]).radius+"*_scale, height:"+(object3d as aTypes[i]).height+"*_scale, segmentsW:"+(object3d as aTypes[i]).segmentsW+", segmentsH:"+(object3d as aTypes[i]).segmentsH+"});";
							break;

						case "WireCube":
							meshString += constructinsert+"{"+nameinsert+wirematinsert+", width:"+(object3d as aTypes[i]).width+"*_scale, height:"+(object3d as aTypes[i]).height+"*_scale, depth:"+(object3d as aTypes[i]).depth+"*_scale});";
							break;

						case "WireCylinder":
							meshString += constructinsert+"{"+nameinsert+wirematinsert+", radius:"+(object3d as aTypes[i]).radius+"*_scale, height:"+(object3d as aTypes[i]).height+"*_scale, segmentsW:"+(object3d as aTypes[i]).segmentsW+", segmentsH:"+(object3d as aTypes[i]).segmentsH+"});";
							break;

						case "WirePlane":
							meshString += constructinsert+"{"+nameinsert+wirematinsert+", width:"+(object3d as aTypes[i]).width+"*_scale, height:"+(object3d as aTypes[i]).height+"*_scale, segmentsW:"+(object3d as aTypes[i]).segmentsW+", segmentsH:"+(object3d as aTypes[i]).segmentsH+"});";
							break;

						case "WireSphere":
							meshString += constructinsert+"{"+nameinsert+wirematinsert+", radius:"+(object3d as aTypes[i]).radius+"*_scale, segmentsW:"+(object3d as aTypes[i]).segmentsW+", segmentsH:"+(object3d as aTypes[i]).segmentsH+"});";
							break;
							 
						case "GeodesicSphere":
							meshString += constructinsert+"{"+nameinsert+bothsidesinsert+"material:"+mat+", radius:"+(object3d as aTypes[i]).radius+"*_scale, fractures:"+(object3d as aTypes[i]).fractures+"});";
							break;
							
						case "GridPlane":
							meshString += constructinsert+"{"+nameinsert+wirematinsert+", width:"+(object3d as aTypes[i]).width+"*_scale, height:"+(object3d as aTypes[i]).height+", segmentsW:"+(object3d as aTypes[i]).segmentsW+", segmentsH:"+(object3d as aTypes[i]).segmentsH+"});";
							break;
							
						case "Skybox":
							meshString += constructinsert+"null,null,null,null,null,null);";
							break;
							
						case "Skybox6":
							meshString += constructinsert+"null);";
							break;
					}
					
					if((object3d as aTypes[i]).rotationX != 0) meshString += "\n\t\t\t"+objname+".rotationX="+(object3d as aTypes[i]).rotationX+";";
					if((object3d as aTypes[i]).rotationY != 0) meshString += "\n\t\t\t"+objname+".rotationY="+(object3d as aTypes[i]).rotationY+";";
					if((object3d as aTypes[i]).rotationZ != 0) meshString += "\n\t\t\t"+objname+".rotationZ="+(object3d as aTypes[i]).rotationZ+";";
					
					if(mesh.pushfront)  meshString += "\n\t\t\t("+objname+" as Mesh).pushfront = true;";
					if(mesh.pushback)  meshString += "\n\t\t\t("+objname+" as Mesh).pushback = true;";
					if(mesh.ownCanvas)  meshString += "\n\t\t\t("+objname+" as Mesh).ownCanvas = true;";
					
					meshString += "\n\t\t\t"+objname+".position= new Vector3D("+xpos+","+ypos+","+zpos+");";
					meshString += "\n\t\t\toList.push("+objname+");";
					
					if(containerid != -1){
						meshString += "\n\t\t\taC["+containerid+"].addChild("+objname+");\n";
					} else{
						meshString += "\n\t\t\taddChild("+objname+");\n";
					}
					
			} else {
					useMesh = true;
					var v:Vector.<Number>;
					var facesIndices:String = "";
					var uvsData:String = "";
					meshString +="\t\t\tvar m"+objcount+":Matrix3D = new Matrix3D();\n";
					v = object3d.transform.rawData;
					meshString +="\t\t\tm"+objcount+".rawData = Vector.<Number>(["+v[0]+","+v[1]+","+v[2]+","+v[3]+","+v[4]+","+v[5]+","+v[6]+","+v[7]+","+v[8]+","+v[9]+","+v[10]+","+v[11]+","+v[12]+","+v[13]+","+v[14]+","+v[15]+"]);\n";
					meshString +="\n\t\t\tobjs.obj"+objcount+" = {"+nameinsert+" transform:m"+objcount+", pivotPoint:new Vector3D("+object3d.pivotPoint.x+","+object3d.pivotPoint.y+","+object3d.pivotPoint.z+"), container:"+containerid+", bothsides:"+(object3d as Mesh).bothsides+", material:"+mat+", ownCanvas:"+(object3d as Mesh).ownCanvas+", pushfront:"+(object3d as Mesh).pushfront+", pushback:"+(object3d as Mesh).pushback+"};";
					
					var aFaces:Vector.<Face> = mesh.faces;
					var vUVs:Vector.<UV> = new Vector.<UV>();
					
					var vVertices:Vector.<Vertex> = mesh.vertices;
					var geometry:Geometry = mesh.geometry;
					var va:int;
					var vb:int;
					var vc:int;
					var vta:int;
					var vtb:int;
					var vtc:int;
					var j:int;
					var face:Face;
					var geoIndex:int;
					
					if ((geoIndex = checkGeometry(geometry)) != -1) {
						meshString +="\n\t\t\tobjs.obj"+objcount+".geo=geos["+geoIndex+"];\n";
					} else {
						
						geoIndex = geos.length;
						geos.push(geometry);
						var delimiter:String;
						var faceloop:int = aFaces.length;
						var comma:int = aFaces.length-1;
						
						for(i = 0; i<faceloop; ++i)
						{
							face = aFaces[i];
							geonums[face] = geoIndex;
							facenums[face] = i;
							delimiter = (i<comma)? "," : "";
							
							facesIndices += getVertIndex( vVertices, face.vertices[0]).toString(16)+",";
							facesIndices += getVertIndex( vVertices, face.vertices[1]).toString(16)+",";
							facesIndices += getVertIndex( vVertices, face.vertices[2]).toString(16)+",";

							vta = getUVIndex( uvsData, vUVs, face.uvs[0]);
							vtb = getUVIndex( uvsData, vUVs, face.uvs[1]);
							vtc = getUVIndex( uvsData, vUVs, face.uvs[2]);
							
							uvsData += delimiter;

							facesIndices += vta.toString(16)+","+vtb.toString(16)+","+vtc.toString(16)+delimiter;
						}
						
						geoString += "\t\t\tvar geo"+geoIndex+"vert:String =\""+encode( getVertString(vVertices))+"\";\n";
						geoString += "\t\t\tvar geo"+geoIndex+"uvs:String =\""+encode( getUVString(vUVs))+"\";\n"; 
						geoString += "\t\t\tvar geo"+geoIndex+"faces:String =\""+facesIndices+"\";\n";
						geoString += "\t\t\tvar geo"+geoIndex+":FacesDefinition = new FacesDefinition();\n";
						geoString += "\t\t\tgeo"+geoIndex+".f = buildFaces( geo"+geoIndex+"faces.split(\",\"),  buildVertices(read(geo"+geoIndex+"vert).split(\",\")), buildUVs(read(geo"+geoIndex+"uvs).split(\",\")) );\n";
						geoString += "\t\t\tgeos.push(geo"+geoIndex+");\n";
						
						meshString +="\n\t\t\tobjs.obj"+objcount+".geo=geos["+geoIndex+"];\n";
					}
			}
			objcount ++;
		}
		
		private function encode(str:String):String
		{
			var start:int= 0;
			var chunk:String;
			var encstr:String = "";
			var charcount:int = str.length;
			for(var i:int = 0;i<charcount;++i){
				if (str.charCodeAt(i)>=48 && str.charCodeAt(i)<= 57 && str.charCodeAt(i)!= 48 ){
					start = i;
					chunk = "";
					while(str.charCodeAt(i)>=48 && str.charCodeAt(i)<= 57 && i<=charcount){
						i++;
					}
					chunk = Number(str.substring(start, i)).toString(16);
					encstr+= chunk;
					i--;
				} else{
					encstr+= str.substring(i, i+1);
				}
			}
			return encstr.replace(p1,"/0/");
		}
		
		private function getVertString(vertices:Vector.<Vertex>):String
		{
			var str:String ="";
			var v:Vertex;
			var delimiter:String;
			var lastentry:int = vertices.length-1;
			
			for(var i:int = 0;i<vertices.length;++i){
				v = vertices[i];
				delimiter = (i<lastentry)? ",":"";
				str += v.x+"/"+v.y+"/"+v.z+delimiter;
			}
			
			return str;
		}
		
		private function getUVString(uvs:Vector.<UV>):String
		{
			var str:String ="";
			var uv:UV;
			var delimiter:String;
			var lastentry:int = uvs.length-1;
			
			for(var i:int = 0;i<uvs.length;++i){
				uv = uvs[i];
				delimiter = (i<lastentry)? ",":"";
				str += uv.u+"/"+uv.v+delimiter;
			}
			
			return str;
		}
		
		private function getVertIndex(vertices:Vector.<Vertex>, v:Vertex):int
		{
			for(var i:int = 0;i<vertices.length;++i)
				if(vertices[i] == v)
					return i;
			 
			return 0;
		}
		
		private function getUVIndex(uvsData:String, uvs:Vector.<UV>, uv:UV):int
		{
			for(var i:int = 0;i<uvs.length;++i)
				if(uvs[i] == uv)
					return i;
			
			uvs.push(uv);
			uvsData += uv.u +"/"+ uv.v;
			
			return uvs.length-1;
		}
		
		private function checkGeometry(geometry:Geometry):int
		{
			for (var i:String in geos)
				if (geos[i] == geometry)
					return Number(i);
			
			return -1;
		}
		
		private  function parse(object3d:Object3D, containerid:int = -1):void
		{
			if(object3d is ObjectContainer3D){
				var obj:ObjectContainer3D = (object3d as ObjectContainer3D);
				
				var id:int = gcount;
				var v:Vector.<Number>;
				if(containerid != -1){
					containerString +="\n\t\t\tvar cont"+id+":ObjectContainer3D = new ObjectContainer3D();\n";
					containerString +="\t\t\taC.push(cont"+id+");\n";
					if (containerid == 0)
						containerString +="\t\t\taddChild(cont"+id+");\n";
					else
						containerString +="\t\t\tcont"+containerid+".addChild(cont"+id+");\n";
					
					containerString +="\t\t\tvar m"+id+":Matrix3D = new Matrix3D();\n";
					v = obj.transform.rawData;
					containerString +="\t\t\tm"+id+".rawData = Vector.<Number>(["+v[0]+","+v[1]+","+v[2]+","+v[3]+","+v[4]+","+v[5]+","+v[6]+","+v[7]+","+v[8]+","+v[9]+","+v[10]+","+v[11]+","+v[12]+","+v[13]+","+v[14]+","+v[15]+"]);\n";
					containerString +="\t\t\ttransform = m"+id+";\n";
					 
					if(obj.name != null) containerString +="\t\t\tcont"+id+".name = \""+obj.name+"\";\n";
					if(obj.pivotPoint.toString() != "x:0 y:0 z:0") containerString +="\t\t\tcont"+id+".movePivot("+obj.pivotPoint.x+","+obj.pivotPoint.y+","+obj.pivotPoint.z+");\n";
				}else{
					containerString += "\t\t\taC.push(this);\n";
					containerString += "\t\t\tvar m"+id+":Matrix3D = new Matrix3D();\n";
					v = obj.transform.rawData;
					containerString +="\t\t\tm"+id+".rawData = Vector.<Number>(["+v[0]+","+v[1]+","+v[2]+","+v[3]+","+v[4]+","+v[5]+","+v[6]+","+v[7]+","+v[8]+","+v[9]+","+v[10]+","+v[11]+","+v[12]+","+v[13]+","+v[14]+","+v[15]+"]);\n";
					containerString +="\t\t\ttransform = m"+id+";\n";
					 
					if (obj.name != null) containerString +="\t\t\tname = \""+obj.name+"\";\n";
					if (obj.pivotPoint.toString() != "x:0 y:0 z:0") containerString +="\t\t\tmovePivot("+obj.pivotPoint.x+","+obj.pivotPoint.y+","+obj.pivotPoint.z+");\n";
				}
				
				gcount++;
				
				for(var i:int =0;i<obj.children.length;i++){
					if(obj.children[i] is ObjectContainer3D){
						parse(obj.children[i], id);
					} else{
						write( obj.children[i], id);
					}
				}
				
				if (containerid != -1) {
					
				} else {
					
					if (obj.materialLibrary != null) {
						materialString +="\t\t\tmaterialLibrary = new MaterialLibrary();\n";
						for each (var materialData:MaterialData in obj.materialLibrary) {
							materialString +="\t\t\tvar mData_"+mcount+":MaterialData = materialLibrary.addMaterial(\""+materialData.name+"\");\n";
							materialString +="\t\t\tmData_"+mcount+".materialType = \""+materialData.materialType+"\";\n";
							materialString +="\t\t\tmData_"+mcount+".ambientColor = "+materialData.ambientColor+";\n";
							materialString +="\t\t\tmData_"+mcount+".diffuseColor = "+materialData.diffuseColor+";\n";
							materialString +="\t\t\tmData_"+mcount+".shininess = "+materialData.shininess+";\n";
							materialString +="\t\t\tmData_"+mcount+".specularColor = "+materialData.specularColor+";\n";
							materialString +="\t\t\tmData_"+mcount+".textureFileName = \""+materialData.textureFileName+"\";\n";
							materialString +="\t\t\tvar mElements_"+mcount+":Array = mData_"+mcount+".elements;\n";
							for each (var meshMaterialData:MeshMaterialData in materialData.meshMaterials) {
								for each (var element:Element in meshMaterialData.elements) {
									if (geonums[element] != null && facenums[element] != null)
										materialString +="\t\t\tmElements_"+mcount+".push(geos["+geonums[element]+"].geometry.faces["+facenums[element]+"]);\n";
								}
							}
							materialString +="\t\t\t\n";
							mcount++;
						}
					}
				}
				
			} else {
				write( object3d, -1);
			}
		}
		
		/**
		* Class generates a string in the Actionscript3 format representing the object3D(s).
		*/
		
		function AS3Exporter(){}
		
		/**
		* Generates a string in the Actionscript3 format representing the object3D(s).
		* The event onComplete, returns in event.data the generated class string.
		*
		* @param	object3d				Object3D. The Object3D to be exported to the AS3 format.
		* @param	classname				Defines the class name used in the output string.
 		* @param	packagename			[optional] Defines the package name used in the output string. Defaults to no package.
		* 
		* Generated class example of use:
		* var myClass:ClassName = new ClassName();
		* view.scene.addChild(myClass);
		* 
		* To access the objects stored into the class:
		* - ClassName.containers, a getter returns the ObjectContainers3D Array.
		* - ClassName.meshes, a getter returns the Mesh Array.
		* 
		*   To access a mesh in the meshes array to change a material
		*   (ClassName.meshes[0] as Mesh).material = myNewMat;
		*/
		
		public function export(object3d:Object3D, classname:String, packagename:String = ""):void
		{
			
			if(hasEventListener(ExporterEvent.COMPLETE)){
				reset();
				
				asString = "//AS3 exporter version 3.0, generated by Away3D: http://www.away3d.com\n";
				asString += "package "+packagename+"\n{\n\timport flash.geom.*;\n\timport away3d.containers.ObjectContainer3D;\n\timport away3d.containers.Scene3D;\n\timport away3d.core.math.*;\n\timport away3d.materials.*;\n\timport away3d.core.base.*;\n\timport away3d.loaders.utils.*;\n\timport away3d.loaders.data.*;\n\timport flash.utils.Dictionary;\n\timport away3d.primitives.*;\n\n";
				parse(object3d);
				
				if(gcount==0)
					asString += "\tpublic class "+classname+" extends Mesh\n\t{\n";
				else 
					asString += "\tpublic class "+classname+" extends ObjectContainer3D\n\t{\n";
				   
				asString += "\t\tprivate var objs:Object = {};\n\t\tprivate var geos:Array = [];\n\t\tprivate var oList:Array =[];\n\t\tprivate var aC:Array;\n\t\tprivate var aV:Array;\n\t\tprivate var aU:Array;\n\t\tprivate var _scale:Number;\n\n";
				asString += "\t\tpublic function "+classname+"(scale:Number = 1)\n\t\t{\n\t\t\t_scale = scale;\n\t\t\tsetSource();\n\t\t\taddContainers();\n\t\t\tbuildMeshes();\n\t\t\tbuildMaterials();\n\t\t\tcleanUp();\n\t\t}\n\n";
				asString += "\t\tprivate function buildMeshes():void\n\t\t{\n";
				asString += meshString;
				
				if(useMesh){
					asString += "\n\t\t\tvar ref:Object;\n\t\t\t";
					
					if(gcount>0)
						asString += "var mesh:Mesh;";
						
					asString += "\n\t\t\tvar j:int;\n\t\t\tvar av:Array;\n\t\t\tvar au:Array;\n\t\t\tvar v0:Vertex;\n\t\t\tvar v1:Vertex;\n\t\t\tvar v2:Vertex;\n\t\t\tvar u0:UV;\n\t\t\tvar u1:UV;\n\t\t\tvar u2:UV;\n\t\t\tvar aRef:Vector.<Face>;\n\t\t\tfor(var i:int = 0;i<"+objcount+";++i){\n";
					asString += "\t\t\t\tref = objs[\"obj\"+i];\n";
					asString += "\t\t\t\tif(ref != null){\n";
					
					var keyobject:String;
					if(gcount==0){
						keyobject = "this";
					}else{
						asString += "\t\t\t\t\tmesh = new Mesh();\n";
						keyobject = "mesh";
					}
					asString += "\t\t\t\t\t"+keyobject+".type = \".as\";\n";
					
					if(isAnim){
						asString += "\t\t\t\t\tif(ref.meshanimated) setMeshAnim("+keyobject+", ref, oList.length);\n";
						asString += "\t\t\t\t\tif(ref.indexes != null) "+keyobject+".indexes = ref.indexes;\n";
					}
					
					asString += "\t\t\t\t\t"+keyobject+".bothsides = ref.bothsides;\n\t\t\t\t\t"+keyobject+".name = ref.name;\n";
					asString += "\t\t\t\t\t"+keyobject+".pushfront = ref.pushfront;\n\t\t\t\t\t"+keyobject+".pushback = ref.pushback;\n\t\t\t\t\t"+keyobject+".ownCanvas = ref.ownCanvas;\n";
					 
					if(gcount>0)
						asString += "\t\t\t\t\tif(aC[ref.container]!= null)\n\t\t\t\t\t\taC[ref.container].addChild("+keyobject+");\n";
					
					asString += "\n\t\t\t\t\toList.push("+keyobject+");";
					asString += "\n\t\t\t\t\t"+keyobject+".transform = ref.transform;\n\t\t\t\t\t"+keyobject+".movePivot(ref.pivotPoint.x, ref.pivotPoint.y, ref.pivotPoint.z);\n";
					asString += "\t\t\t\t\tif (ref.geo.geometry != null) {\n";
					asString += "\t\t\t\t\t\t"+keyobject+".geometry = ref.geo.geometry;\n";
					asString += "\t\t\t\t\t\tcontinue;\n";
					asString += "\t\t\t\t\t}\n";
					asString += "\t\t\t\t\tref.geo.geometry = new Geometry();\n";
					asString += "\t\t\t\t\t"+keyobject+".geometry = ref.geo.geometry;\n";
					
					asString += "\t\t\t\t\taRef = ref.geo.f;\n";
					asString += "\t\t\t\t\tfor(j = 0;j<aRef.length;++j){\n";
					asString += "\t\t\t\t\t\tFace(aRef[j]).material = ref.material;\n";
					asString += "\t\t\t\t\t\tref.geo.geometry.addFace( Face(aRef[j]));\n";
					asString += "\t\t\t\t\t}\n";
					
					asString += "\n\t\t\t\t}\n\t\t\t}\n";
					
					asString += "\t\t}";
					asString += "\n\n\t\tprivate function setSource():void\n\t\t{\n";
					asString += geoString;
					asString += "\t\t}";
				} else{
					asString += "\t\t}";
					asString += "\n\n\t\tprivate function setSource():void\n\t\t{}\n";
				}
				
				asString += "\n\n\t\tprivate function buildFaces(aFaces:Array, vVerts:Vector.<Vertex>, vUVs:Vector.<UV>):Vector.<Face>";
				asString += "\n\t\t{";
				asString += "\n\t\t\tvar vFaces:Vector.<Face> = new Vector.<Face>();";
				asString += "\n\t\t\tvar f:Face;";
				asString += "\n\t\t\tfor(var i:int = 0;i<aFaces.length;i+=6){";
				asString += "\n\t\t\t\tf = new Face( vVerts[parseInt(aFaces[i], 16)],";
				asString += "\n\t\t\t\t\t\t\t\t\tvVerts[parseInt(aFaces[i+1], 16)],";
				asString += "\n\t\t\t\t\t\t\t\t\tvVerts[parseInt(aFaces[i+2], 16)],";
				asString += "\n\t\t\t\t\t\t\t\t\tnull,";
				asString += "\n\t\t\t\t\t\t\t\t\tvUVs[parseInt(aFaces[i+3], 16)],";
				asString += "\n\t\t\t\t\t\t\t\t\tvUVs[parseInt(aFaces[i+4], 16)],";
				asString += "\n\t\t\t\t\t\t\t\t\tvUVs[parseInt(aFaces[i+5], 16)]);";
				asString += "\n\t\t\t\tvFaces.push(f);";
				asString += "\n\t\t\t}\n";
				asString += "\n\t\t\treturn vFaces;";
				asString += "\n\t\t}\n";
				
				asString += "\n\t\tprivate function buildVertices(aVerts:Array):Vector.<Vertex>";
				asString += "\n\t\t{";
				asString += "\n\t\t\tvar tmpv:Array;";
				asString += "\n\t\t\tvar vVerts:Vector.<Vertex> = new Vector.<Vertex>();";
				asString += "\n\t\t\tfor(var i:int = 0;i<aVerts.length;i++){";
				asString += "\n\t\t\t\ttmpv = aVerts[i].split(\"/\");";
				asString += "\n\t\t\t\tvVerts[i] = new Vertex( parseFloat(tmpv[0])*_scale, parseFloat(tmpv[1])*_scale, parseFloat(tmpv[2])*_scale  );";
				asString += "\n\t\t\t}";
				asString += "\n\t\t\treturn vVerts;\n\t\t}\n";
				
				asString += "\n\t\tprivate function buildUVs(aUvs:Array):Vector.<UV>";
				asString += "\n\t\t{";
				asString += "\n\t\t\tvar tmpv:Array;";
				asString += "\n\t\t\tvar vUVs:Vector.<UV> = new Vector.<UV>();";
				asString += "\n\t\t\tfor(var i:int = 0;i<aUvs.length;++i){";
				asString += "\n\t\t\t\ttmpv = aUvs[i].split(\"/\");";
				asString += "\n\t\t\t\tvUVs[i] = new UV(parseFloat(tmpv[0]), parseFloat(tmpv[1]));";
				asString += "\n\t\t\t}\n";
				asString += "\n\t\t\treturn vUVs;\n\t\t}\n";
				
				asString += "\n\t\tprivate function buildMaterials():void\n\t\t{";
				asString += materialString;
				asString += "\n\t\t}\n";
				asString += "\n\t\tprivate function cleanUp():void\n\t\t{";
				asString += "\n\t\t\tfor(var i:int = 0;i<"+objcount+";++i){\n\t\t\t\tobjs[\"obj\"+i] == null;\n\t\t\t}\n\t\t\taV = null;\n\t\t\taU = null;\n\t\t}";
				
				if(isAnim){
					asString += "\n\n\t\tprivate function setMeshAnim(mesh:Mesh, obj:Object, id:int):void\n\t\t{\n";
					asString += "\n\t\t\ttrace(\"\\nAnimation frames prefixes for : this.meshes[\"+id+\"]\");";
					asString += "\n\t\t\tmesh.geometry.frames = new Dictionary();";
					asString += "\n\t\t\tmesh.geometry.framenames = new Dictionary();";
					asString += "\n\t\t\tvar y:int;\n";
					asString += "\t\t\tvar z:int;\n";
					asString += "\t\t\tvar frame:Frame;\n";
					asString += "\t\t\tvar vp:VertexPosition;\n";
					asString += "\t\t\tfor(var i:int = 0;i<obj.fnarr.length; ++i){\n";
					asString += "\t\t\t\ttrace(\"[ \"+obj.fnarr[i]+\" ]\");\n";
					asString += "\t\t\t\tframe = new Frame();\n";
					asString += "\t\t\t\tmesh.geometry.framenames[obj.fnarr[i]] = i;\n";
					asString += "\t\t\t\tmesh.geometry.frames[i] = frame;\n";
					asString += "\t\t\t\tz=0;\n";
					asString += "\t\t\t\tfor (y = 0; y < obj[\"fr\"+obj.fnarr[i]].length; y+=3){\n";
					asString += "\t\t\t\t\tvp = new VertexPosition(mesh.vertices[z]);\n";
					asString += "\t\t\t\t\tz++;\n";
					asString += "\t\t\t\t\tvp.x = obj[\"fr\"+obj.fnarr[i]][y]*_scale;\n";
					asString += "\t\t\t\t\tvp.y = obj[\"fr\"+obj.fnarr[i]][y+1]*_scale;\n";
					asString += "\t\t\t\t\tvp.z = obj[\"fr\"+obj.fnarr[i]][y+2]*_scale;\n";
					asString += "\t\t\t\t\tframe.vertexpositions.push(vp);\n";
					asString += "\t\t\t\t}\n";
					asString += "\t\t\t\tif (i == 0)\n";
					asString += "\t\t\t\t\tframe.adjust();\n";
					asString += "\t\t\t}\n";
					asString += "\t\t}";
				}
				 
				if(containerString != ""){
					asString += "\n\n\t\tprivate function addContainers():void\n\t\t{\n";
					asString += "\n\t\t\taC = [];\n";
					asString += containerString+"\n";
					asString += "\t\t}";
					asString += "\n\n\t\tpublic function get containers():Array\n\t\t{\n";
					asString += "\t\t\treturn aC;\n";
					asString += "\t\t}\n";
				} else{
					  asString += "\n\n\t\tprivate function addContainers():void\n\t\t{}\n";
				}
				
				asString += "\n\n\t\tpublic function get meshes():Array\n\t\t{\n";
				asString += "\t\t\treturn oList;\n\t\t}\n";
				
				asString += "\n\n\t\tprivate function read(str:String):String\n\t\t{\n";
				asString += "\t\t\tvar start:int= 0;\n";
				asString += "\t\t\tvar chunk:String;\n";
				asString += "\t\t\tvar end:int= 0;\n";
				asString += "\t\t\tvar dec:String = \"\";\n";
				asString += "\t\t\tvar charcount:int = str.length;\n";
				asString += "\t\t\tfor(var i:int = 0;i<charcount;++i){\n";
				asString += "\t\t\t\tif (str.charCodeAt(i)>=44 && str.charCodeAt(i)<= 48 ){";
				asString += "\n\t\t\t\t\tdec+= str.substring(i, i+1);";
				asString += "\n\t\t\t\t}else{";
				asString += "\n\t\t\t\t\tstart = i;";
				asString += "\n\t\t\t\t\tchunk = \"\";";
				asString += "\n\t\t\t\t\twhile(str.charCodeAt(i)!=44 && str.charCodeAt(i)!= 45 && str.charCodeAt(i)!= 46 && str.charCodeAt(i)!= 47 && i<=charcount){";
				asString += "\n\t\t\t\t\t\ti++;";
				asString += "\n\t\t\t\t\t}";
				asString += "\n\t\t\t\t\tchunk = \"\"+parseInt(\"0x\"+str.substring(start, i), 16 );";
				asString += "\n\t\t\t\t\tdec+= chunk;";
				asString += "\n\t\t\t\t\ti--;";
				asString += "\n\t\t\t\t}\n";
				asString += "\t\t\t}\n";
				asString += "\t\t\treturn dec;";
				asString += "\n\t\t}\n";
				
				asString += "\n\t}\n}\n";
				
				asString += "class FacesDefinition\n{";
				asString += "\n\timport away3d.core.base.Face;"
				asString += "\n\timport away3d.core.base.Geometry;"
				asString += "\n\tpublic var f:Vector.<Face>;"
				asString += "\n\tpublic var geometry:Geometry;\n}";
								
				var EE:ExporterEvent = new ExporterEvent(ExporterEvent.COMPLETE);
				EE.data = asString;
				dispatchEvent(EE);
				
			} else {
				trace("AS3Exporter Error:\nNo ExporterEvent.COMPLETE event set.\nUse the method addOnExportComplete(myfunction) before use export();\n");
			}
		}
		
		/**
		 * Default method for adding a complete event listener
		 * The event.data holds the generated string from the wavefront class
		 * 
		 * @param	listener		The listener function
		 */
		public function addOnExportComplete(listener:Function):void
        {
			addEventListener(ExporterEvent.COMPLETE, listener, false, 0, false);
        }
		/**
		 * Default method for removing a complete event listener
		 * 
		 * @param	listener		The listener function
		 */
		public function removeOnExportComplete(listener:Function):void
        {
            removeEventListener(ExporterEvent.COMPLETE, listener, false);
        }
		/**
		 * Returns the last generated as3 file async from events.
		 */
		public function get as3File():String
		{
			return asString;
		}
		
	}
}