//Potrzebujemy liczby losowej.
int randNumber;

// Lewe koło HUB-ee jest podłączone do pinów D6, D7 i D8.
#define leftPWM 6
#define leftIN1 7
#define leftIN2 8

// Prawe koło HUB-ee jest podłączone do pinów D9, D10 i D11.
#define rightPWM 9
#define rightIN1 10
#define rightIN2 11

void setup() {
//Inicjalizuj generator liczb losowych.
   randomSeed(analogRead(0));

//Inicjalizuj wspomniane wcześniej piny.
   pinMode(leftPWM, OUTPUT);
   pinMode(leftIN1, OUTPUT);
   pinMode(leftIN2, OUTPUT);

   pinMode(rightPWM, OUTPUT);
   pinMode(rightIN1, OUTPUT);
   pinMode(rightIN2, OUTPUT);
}

void loop() {
   randNumber = random(1000);
//Sprawdźmy działanie czterech funkcji określających kierunek ruchu robota. 
// Liczby losowe będą określały czas obracania się kół wyrażony w milisekundach.
//W razie potrzeby zwiększ wartość random();.

   leftTurn(100, randNumber);
   delay(500);
   rightTurn(100, randNumber);
   delay(500);
   goForward(100, randNumber);
   delay(500);
   goBackward(100, randNumber);
   delay(500);
}

//Oto funkcja sprawiająca, że pojazd skręci w prawo.
//Jeżeli podłączyłeś przewody silnika odwrotnie (inaczej niż ja), 
// to będziesz musiał zamienić ze sobą wartości HIGH i LOW.

int rightTurn(int rtPWM, int rtDelay){

   digitalWrite(leftIN1, LOW);
   digitalWrite(leftIN2, HIGH);
   analogWrite(leftPWM, rtPWM);

   digitalWrite(rightIN1, HIGH);
   digitalWrite(rightIN2, LOW);
   analogWrite(rightPWM, rtPWM);
   delay(rtDelay);
}

//Funkcja skręcająca w lewo...

   int leftTurn(int ltPWM, int ltDelay){
   digitalWrite(leftIN1, HIGH);
   digitalWrite(leftIN2, LOW);

   analogWrite(leftPWM, ltPWM);
   digitalWrite(rightIN1, LOW);
   digitalWrite(rightIN2, HIGH);
   analogWrite(rightPWM, ltPWM);
   delay(ltDelay);
}

//Funkcja, dzięki której robot jedzie do przodu.

int goForward(int gfPWM, int gfDelay){

   digitalWrite(leftIN1, HIGH);
   digitalWrite(leftIN2, LOW);
   analogWrite(leftPWM, gfPWM);

   digitalWrite(rightIN1, HIGH);
   digitalWrite(rightIN2, LOW);
   analogWrite(rightPWM, gfPWM);
   delay(gfDelay);
}

// Funkcja, dzięki której robot jedzie do tyłu.

int goBackward(int gbPWM, int gbDelay){

   digitalWrite(leftIN1, LOW);
   digitalWrite(leftIN2, HIGH);
   analogWrite(leftPWM, gbPWM);

   digitalWrite(rightIN1, LOW);
   digitalWrite(rightIN2, HIGH);
   analogWrite(rightPWM, gbPWM);
   delay(gbDelay); 
}

