// W niniejszym szkicu zastosowano fragmenty przykładowych szkiców Servo i NECRemote.
#include <Adafruit_NECremote.h>
#include <Servo.h>

int LED = 13;
int PIRinputPin = 3;
int pirState = LOW; // Początkowy stan czujnika ruchu: LOW.
int val = 0;
int IRinput = 7;
Servo myservo;
int pos = 90; // Wyreguluj obrót serwomotoru tak, aby rzutka była wystrzeliwana.
int status = 1;

Adafruit_NECremote remote(IRinput);

void setup() {
   Serial.begin(9600);
   pinMode(LED, OUTPUT);
   pinMode(PIRinputPin, INPUT);
   pinMode(IRinput, INPUT);
   myservo.attach(9);

   myservo.write(60); // Początkowe położenie serwomotoru

}

void loop(void){
   int c = remote.listen(5);
   Serial.println(c);

   if (c==9){
      status = 1;
   }

   else if (c==10){
      status = 2;
   }

   switch(status) {

   case 1:
      Serial.println("rozbrojony");

      digitalWrite (LED, LOW);
      delay(500);
      break;

   case 2:
      // status 2.: uzbrojony
      Serial.println("uzbrojony");

      val = digitalRead(PIRinputPin);
      if (val == HIGH) {
      myservo.write(pos);
      Serial.println("BUM!");
      status = 3;
      }

      else
      digitalWrite (LED, HIGH);
      delay(100);
      break;

   case 3:
      Serial.println("wystrzelono");

      digitalWrite (LED, HIGH);
      delay(10);
      digitalWrite (LED, LOW);
      delay(10);
      break;
   }
}

