namespace ReactivePiglets

open WebSharper
open WebSharper.JavaScript
open WebSharper.UI.Next
open WebSharper.UI.Next.Html
open WebSharper.UI.Next.Client
open WebSharper.Forms

[<JavaScript>]
module LoginForm =

    let Main =
        Form.Return (fun user pass -> (user, pass))
        <*> (Form.Yield ""
            |> Validation.IsNotEmpty "Podaj nazwe")
        <*> (Form.Yield ""
            |> Validation.IsNotEmpty "Podaj haslo")
        |> Form.WithSubmit
        |> Form.Run (fun (user, pass) ->
            JS.Alert ("Welcome, " + user + "!"))
        |> Form.Render (fun user pass submit ->
            div [
                div [label [text "Nazwa: "]; Doc.Input [] user]
                div [label [text "Haslo: "]; Doc.PasswordBox [] pass]
                Doc.Button "Log in" [] submit.Trigger
                div [
                    Doc.ShowErrors submit.View (fun errors ->
                        errors
                        |> List.map (fun error -> p [text error.Text])
                        |> Seq.cast
                        |> Doc.Concat)
                ]
            ]
        )
        |> fun s -> s.RunById "main"
