namespace Acme.NumberTheory

module NumberTheoryExtensions =
    let private isPrime i =
        let lim = int (sqrt (float i))
        let rec check j =
           j > lim || (i % j <> 0 && check (j+1))
        check 2

    type System.Int32 with
        member i.IsPrime = isPrime i

// UWAGA: Files loaded into F# interactive with load have their values and types
// placed in a namespace or module according to the leading module or namespace
// declaration in the file.
// UWAGA: wczytywanie plików do F# Interactive powoduje umieszczenie
// wartości i typów z pliku w przestrzeni nazw lub module (zgodnie 
// z początkową deklaracją z pliku - namespace lub module).
[<assembly:AutoOpen("Acme.NumberTheory.NumberTheoryExtensions")>]
do()
