namespace Piglets

open WebSharper
open WebSharper.JavaScript
open WebSharper.Html.Client
open WebSharper.Piglets

[<JavaScript>]
module LoginForm =

    let Main =
        Piglet.Return (fun user pass -> (user, pass))
        <*> (Piglet.Yield ""
            |> Validation.IsNotEmpty "Podaj nazwe")
        <*> (Piglet.Yield ""
            |> Validation.IsNotEmpty "Podaj haslo")
        |> Piglet.WithSubmit
        |> Piglet.Run (fun (user, pass) ->
            JS.Alert ("Witaj, " + user + "!"))
        |> Piglet.Render (fun user pass submit ->
            Div [
                Div [Label [Text "Nazwa: "]; Controls.Input user]
                Div [Label [Text "Haslo: "]; Controls.Password pass]
                Controls.Button submit -< [Text "Zaloguj"]
                Div [] |> Controls.ShowErrors submit (fun errors ->
                    List.map (fun error -> P [Text error]) errors)
            ]
        )
        |> fun s -> s.AppendTo "main"
