(*

# Setup.fsx

Dodaje do rejestru klucze podobne do odpowiedniej obsługi projektów F# Web.

**Problem**: czyste projekty F# Web domyślnie nie działają dobrze w Visual Studio
(przede wszystkim niemożliwe jest dodawanie do projektów nowych elementów).

**Rozwiązanie**: mamy nadzieję, że problem zostanie rozwiązany w przyszłych wersjach Visual Studio.

**Tymczasowe rozwiązanie**: problem dodawania nowych elementów można rozwiązać, dodając odpowiednie
klucze do rejestru. Ten skrypt robi właśnie to. Po jego wykonaniu możesz usunąć ten plik z projektu.

Autorzy: Daniel Mohl [1], Mark Seemann.

[1]: http://bloggemdano.blogspot.com/2013/11/adding-new-items-to-pure-f-aspnet.html

*)

open Microsoft.Win32

type RegistryKeyName =
    | HKCU of string
    | HKLM of string

type RegistryKey with

    static member Find(name) =
        let (r, s) =
            match name with
            | HKCU s -> (Registry.CurrentUser, s)
            | HKLM s -> (Registry.LocalMachine, s)
        (r, s.Split([| '\\' |]))
        ||> Seq.fold (fun s t -> s.OpenSubKey(t))

let Guid = "{F2A71F9B-5D33-465A-A702-920D77279786}"

let AddRegistryKeys (product, key) =
    try
        RegistryKey.Find(key)
            .OpenSubKey("LanguageTemplates", true)
            .SetValue(Guid, Guid, RegistryValueKind.String)
        printfn "Dodan do %s" product
    with _ ->
        printfn "Nie udało się wykryć: %s" product

let InstallFSharpWebCapability () =
    [
        "VWD Express 11", HKCU @"Software\Microsoft\VWDExpress\11.0_Config\Projects\{349C5851-65DF-11DA-9384-00065B846F21}"
        "VWD Express 12", HKCU @"Software\Microsoft\VWDExpress\12.0_Config\Projects\{349C5851-65DF-11DA-9384-00065B846F21}"
        "VWD Express 14", HKCU @"Software\Microsoft\VWDExpress\14.0_Config\Projects\{349C5851-65DF-11DA-9384-00065B846F21}"
        "VS 11", HKCU @"Software\Microsoft\VisualStudio\11.0_Config\Projects\{349C5851-65DF-11DA-9384-00065B846F21}"
        "VS WinDesktop Express 12", HKCU @"Software\Microsoft\VSWinDesktopExpress\12.0_Config\Projects\{349C5851-65DF-11DA-9384-00065B846F21}"
        "VS 12", HKCU @"Software\Microsoft\VisualStudio\12.0_Config\Projects\{349C5851-65DF-11DA-9384-00065B846F21}"
        "VS WinDesktop Express 14", HKCU @"Software\Microsoft\VSWinDesktopExpress\14.0_Config\Projects\{349C5851-65DF-11DA-9384-00065B846F21}"
        "VS 14", HKCU @"Software\Microsoft\VisualStudio\14.0_Config\Projects\{349C5851-65DF-11DA-9384-00065B846F21}"
        "VWD Express 11 (x64)", HKLM @"SOFTWARE\Wow6432Node\Microsoft\VWDExpress\11.0\Projects\{349C5851-65DF-11DA-9384-00065B846F21}"
        "VWD Express 12 (x64)", HKLM @"SOFTWARE\Wow6432Node\Microsoft\VWDExpress\12.0\Projects\{349C5851-65DF-11DA-9384-00065B846F21}"
        "VWD Express 14 (x64)", HKLM @"SOFTWARE\Wow6432Node\Microsoft\VWDExpress\14.0\Projects\{349C5851-65DF-11DA-9384-00065B846F21}"
        "VS 11 (x64)", HKLM @"SOFTWARE\Wow6432Node\Microsoft\VisualStudio\11.0\Projects\{349C5851-65DF-11DA-9384-00065B846F21}"
        "VS WinDesktop Express 12 (x64)", HKLM @"SOFTWARE\Wow6432Node\Microsoft\VSWinDesktopExpress\12.0\Projects\{349C5851-65DF-11DA-9384-00065B846F21}"
        "VS 12 (x64)", HKLM @"SOFTWARE\Wow6432Node\Microsoft\VisualStudio\12.0\Projects\{349C5851-65DF-11DA-9384-00065B846F21}"
        "VS WinDesktop Express 14 (x64)", HKLM @"SOFTWARE\Wow6432Node\Microsoft\VSWinDesktopExpress\14.0\Projects\{349C5851-65DF-11DA-9384-00065B846F21}"
        "VS 14 (x64)", HKLM @"SOFTWARE\Wow6432Node\Microsoft\VisualStudio\14.0\Projects\{349C5851-65DF-11DA-9384-00065B846F21}"
    ]
    |> List.iter AddRegistryKeys

InstallFSharpWebCapability ()
