﻿module Test2

open System
open NUnit.Framework
open IsPalindrome

[<TestFixture;
  Description("Otoczenie testów dla funkcji isPalindrome")>]
type Test() =
    [<TestFixtureSetUp>]
    member x.InitTestFixture () =
        printfn "Przed uruchomieniem otoczenia testów"

    [<TestFixtureTearDown>]
    member x.DoneTestFixture () =
        printfn "Po wykonaniu otoczenia testów"

    [<SetUp>]
    member x.InitTest () =
        printfn "Przed uruchomieniem testu"

    [<TearDown>]
    member x.DoneTest () =
        Console.WriteLine("Po wykonaniu testu")

    [<Test;
      Category("Przypadek specjalny");
      Description("Pusty łańcuch znaków jest palindromem")>]
    member x.EmptyString () =
        Assert.That(isPalindrome(""), Is.True,
                      "isPalindrome musi zwracać true dla pustego łańcucha znaków")

