var sendgrid  = require('sendgrid')(process.env.SENDGRID_USERNAME,
  process.env.SENDGRID_PASSWORD);

var adminEmail = process.env.EMAIL || 'admin.hackhall@mailinator.com';

var _send = function(email, callback) {
  var finalEmail = {
    to:       email.to,
    from:     'hi@hackhall.com',
    subject:  email.subject,
    text:     email.text + '\r\n\r\n http://hackhall.com '
  }
  if (email.bcc)
    finalEmail.bcc = email.bcc
  sendgrid.send(finalEmail, function(err, json) {
    if (err) {
      console.error(err);
      return callback(err);
    }
    console.log(json);
    callback(null, json);
  });
};

exports.notifyNewApplication = function(user, callback) {
  var emailToApplicant = {
    to: user.email,
    bcc: adminEmail,
    subject: 'Ubiegasz się o członkostwo w HackHall.com',
    text: 'Dziękujemy za chęć dołączenia do społeczności HackHall.com. Jednak w celu dołączenia do społeczności musisz zgodzić się na wniesienie opłaty, co wymaga podania informacji o karcie kredytowej. Czy widzisz przycisk uwierzytelnienia? http://hackhall.com/#application'
  }
  _send(emailToApplicant, function(error, json){
    if (error) return callback(error)
    var emailToAdmin = {
      to: adminEmail,
      subject: 'Nowa aplikacja',
      text: 'Pojawiła się nowa aplikacja od ' + user.email + '. Płatność: ' + (user.stripeToken!=null) +
        '. ID: ' + user._id
    };
    _send(emailToAdmin, callback);
  })

};

exports.notifyApproved = function(user, callback) {
  var email = {
    to: user.email,
    bcc: adminEmail,
    subject: 'Zostałeś przyjęty do HackHall',
    text: 'Zostałeś przyjęty do HackHall. \r\n Witamy! '
  };
  _send(email, callback);
};


exports.notifyCc = function(user, callback){
  var email = {
    to: adminEmail,
    subject: 'Nowa karta kredytowa do przetworzenia',
    text:  'Pojawiła się nowa karta kredytowa od ' + user.email +
      '. ID: ' + user._id
  }
  _send(email, callback);
}