var express = require('express'),
  path = require('path'),
  logger = require('morgan'),
  favicon = require('serve-favicon'),
  errorhandler = require('errorhandler');

var app = express();
var router = express.Router();

app.set('view engine', 'jade');
app.set('port', process.env.PORT || 3000);
app.use(logger('combined'));
app.use(favicon(path.join(__dirname, 'public', 'favicon.ico')));
app.use(express.static('public'));

var users = {
  'azat': {
    email: 'hi@azat.co',
    website: 'http://azat.co',
    blog: 'http://webapplog.com'
  }
};

var findUserByUsername = function (username, callback) {
  // Wykonanie zapytania do bazy danych. Po zakończeniu zapytania nastąpi wykonanie wywołania zwrotnego.
  // To jest nasza imitacja bazy danych.
  if (!users[username])
    return callback(new Error(
      'Nie znaleziono użytkownika '
       + username
      )
    );
  return callback(null, users[username]);
};

app.get('/v1/users/:username', function(request, response, next) {
  var username = request.params.username;
  findUserByUsername(username, function(error, user) {
    if (error) return next(error);
    return response.render('user', user);
  });
});

app.get('/v1/admin/:username', function(request, response, next) {
  var username = request.params.username;
  findUserByUsername(username, function(error, user) {
    if (error) return next(error);
    return response.render('admin', user);
  });
});


var findUserByUsernameMiddleware = function(request, response, next){
  if (request.params.username) {
    console.log(
      'Wykryto parametr username: ',
      request.params.username
    );
    findUserByUsername(
      request.params.username,
      function(error, user){
        if (error) return next(error);
        request.user = user;
        return next();
      }
    );
  } else {
    return next();
  }
}
app.get('/v2/users/:username',
  findUserByUsernameMiddleware,
  function(request, response, next){
  return response.render('user', request.user);
});
app.get('/v2/admin/:username',
  findUserByUsernameMiddleware,
  function(request, response, next){
  return response.render('admin', request.user);
});




app.param('v3Username', function(request, response, next, username){
  console.log(
    'Wykryto parametr username: ',
    username
  )
  findUserByUsername(
    username,
    function(error, user){
      if (error) return next(error);
      request.user = user;
      return next();
    }
  );
});

app.get('/v3/users/:v3Username',
  function(request, response, next){
    return response.render('user', request.user);
  }
);
app.get('/v3/admin/:v3Username',
  function(request, response, next){
    return response.render('admin', request.user);
  }
);

router.param('username', function(request, response, next, username){
  console.log(
    'Wykryto parametr username: ',
    username
  )
  findUserByUsername(
    username,
    function(error, user){
      if (error) return next(error);
      request.user = user;
      return next();
    }
  );
})
router.get('/users/:username',
  function(request, response, next){
    return response.render('user', request.user);
  }
);
router.get('/admin/:username',
  function(request, response, next){
    return response.render('admin', request.user);
  }
);
app.use('/v4', router);

app.use(errorhandler());
var server = app.listen(app.get('port'), function() {
  console.log('Serwer Express nasłuchuje na porcie ' + server.address().port);
});
