var express = require('express');
var fs = require('fs');
var path = require('path');
var favicon = require('serve-favicon');
var logger = require('morgan');
var cookieParser = require('cookie-parser');
var bodyParser = require('body-parser');

var routes = require('./routes/index');

var largeImagePath = path.join(__dirname, 'files', 'large-image.jpg');

var app = express();

// Konfiguracja silnika widoku.
app.set('views', path.join(__dirname, 'views'));
app.set('view engine', 'jade');
//app.set('jsonp callback name', 'cb');

app.use(logger('combined'));
app.use(favicon(path.join(__dirname, 'public', 'favicon.ico')));
app.use(bodyParser.json());
app.use(bodyParser.urlencoded({extended: true}));
app.use(cookieParser('abc'));
app.use(express.static(path.join(__dirname, 'public')));

app.use('/', routes);

app.get('/render', function(req, res) {
  res.render('render');
});

app.get('/render-title', function(req, res) {
  res.render('index', {title: 'Pro Express.js'});
});

app.get('/locals', function(req, res){
  res.locals = { title: 'Pro Express.js' };
  res.render('index');
});

app.get('/set-html', function(req, res) {
  // Some code
  res.set('Content-Type', 'text/html');
  res.end('<html><body>' +
    '<h1>Przewodnik po Express.js</h1>' +
    '</body></html>');
});


app.get('/set-csv', function(req, res) {
  var body = 'title, tags\n' +
    'Node.js w praktyce, node.js express.js\n' +
    'Rapid Prototyping with JS, backbone.js node.js mongodb\n' +
    'JavaScript - mocne strony, javascript\n'
  res.set({'Content-Type': 'text/csv',
    'Content-Length': body.length,
    'Set-Cookie': ['type=reader', 'language=javascript']});
  res.end(body);
});

app.get('/status', function(req, res) {
  res.status(200).end();
});


app.get('/send-ok', function(req, res) {
  res.status(200).send({message: 'Przekazanie danych zakończyło się powodzeniem.'});
});

app.get('/send-err', function(req, res) {
  res.status(500).send({message: 'Ups, serwer nie działa.'});
});

app.get('/send-buf', function(req, res) {
  res.set('Content-Type', 'text/plain');
  res.status(200).send(new Buffer('Dane tekstowe, które zostaną skonwertowane na bufor.'));
});


app.get('/json', function(req, res) {
  res.status(200).json([{title: 'Node.js w praktyce', tags: 'node.js express.js'},
    {title: 'Rapid Prototyping with JS', tags: 'backbone.js node.js mongodb'},
    {title: 'JavaScript - mocne strony', tags: 'javascript'}
  ]);
});

app.get('/jsonp', function(req, res) {
  res.status(200).jsonp([{title: 'Przewodnik po Express.js', tags: 'node.js express.js'}, {title: 'Rapid Prototyping with JS', tags: 'backbone.js node.js mongodb'}, {title: 'JavaScript - mocne strony', tags: 'javascript'}]);
});

app.get('/non-stream', function(req, res) {
  var file = fs.readFileSync(largeImagePath);
  res.end(file);
});

app.get('/non-stream2', function(req, res) {
  var file = fs.readFile(largeImagePath, function(error, data){
    res.end(data);
  });
});

app.get('/stream1', function(req, res) {
  var stream = fs.createReadStream(largeImagePath);
  stream.pipe(res);
});


app.get('/stream2', function(req, res) {
  var stream = fs.createReadStream(largeImagePath);
  stream.on('data', function(data) {
    res.write(data);
  });
  stream.on('end', function() {
    res.end();
  });
});


/// Przechwycenie błędu 404 i przekazanie go procedurze obsługi błędów.
app.use(function(req, res, next) {
    var err = new Error('Nie znaleziono.');
    err.status = 404;
    next(err);
});

// Procedury obsługi błędów.

// Procedura obsługi błędów dla środowiska programistycznego.
// Wyświetlenie stosu wywołań.
if (app.get('env') === 'development') {
    app.use(function(err, req, res, next) {
        res.status(err.status || 500);
        res.render('error', {
            message: err.message,
            error: err
        });
    });
}

// Procedura obsługi błędów dla środowiska produkcyjnego.
// Bez wyświetlenia stosu wywołań.
app.use(function(err, req, res, next) {
    res.status(err.status || 500);
    res.render('error', {
        message: err.message,
        error: {}
    });
});


module.exports = app;

var debug = require('debug')('request');


app.set('port', process.env.PORT || 3000);

var server = app.listen(app.get('port'), function() {
  debug('Serwer Express nasłuchuje na porcie ' + server.address().port);
});
