module.exports = function mountLoopBackExplorer(server) {
  var explorer;
  try {
    explorer = require('loopback-explorer');
  } catch(err) {
    // Komunikat zostanie wyświetlony tylko po uruchomieniu aplikacji za pomocą `server.listen()`.
    // Żaden komunikat nie zostanie wyświetlony po użyciu projektu jako komponentu.
    server.once('started', function(baseUrl) {
      console.log(
        'Wydaj polecenie `npm install loopback-explorer`, aby włączyć eksploratora LoopBack.'
      );
    });
    return;
  }

  var restApiRoot = server.get('restApiRoot');

  var explorerApp = explorer(server, { basePath: restApiRoot });
  server.use('/explorer', explorerApp);
  server.once('started', function() {
    var baseUrl = server.get('url').replace(/\/$/, '');
    // express 4.x (loopback 2.x) używa `mountpath`
    // express 3.x (loopback 1.x) używa `route`
    var explorerPath = explorerApp.mountpath || explorerApp.route;
    console.log('API REST możesz przeglądać pod adresem %s%s', baseUrl, explorerPath);
  });
};
