var loopback = require('loopback');
var boot = require('loopback-boot');

var app = module.exports = loopback();

app.start = function() {
  // Uruchomienie serwera WWW.
  return app.listen(function() {
    app.emit('started');
    console.log('Serwer WWW nasłuchuje na porcie: %s', app.get('url'));
  });
};

// Przygotowanie aplikacji, konfiguracja modeli, źródeł danych i oprogramowania pośredniczącego.
// Subaplikacje, takie jak API REST są montowane za pomocą skryptów.
boot(app, __dirname, function(err) {
  if (err) throw err;

  // Uruchomienie serwera po wydaniu polecenia `$ node server.js`.
  if (require.main === module)
    app.start();
});
