var bcrypt = require('bcryptjs');

var user3 = {
  firstName: 'Dummy',
  lastName: 'Application',
  displayName: 'Dummy Application',
  password: bcrypt.hashSync('3', 10),
  email: '3@3.com',
  headline: 'Dummy Appliation',
  photoUrl: '/img/user.png',
  angelList: {blah:'blah'},
  angelUrl: 'http://angel.co.com/someuser',
  twitterUrl: 'http://twitter.com/someuser',
  facebookUrl: 'http://facebook.com/someuser',
  linkedinUrl: 'http://linkedin.com/someuser',
  githubUrl: 'http://github.com/someuser'
}


var bcrypt = require('bcryptjs');
var app = require ('../server').app,
  assert = require('assert'),
  request = require('superagent');

app.listen(app.get('port'), function(){
  console.log('Serwer Express nasłuchuje na porcie ' + app.get('port'));
});

var user1 = request.agent();
var port = 'http://localhost:'+app.get('port');
var userId;

var adminUser = {
  email: 'admin-test@test.com',
  password: 'admin-test'
};

suite('APPLICATION API', function (){
  suiteSetup(function(done){
    done();
  });
  test('Zalogowanie jako administrator.', function(done){
    user1.post(port+'/api/login').send(adminUser).end(function(res){
        assert.equal(res.status,200);
      done();
    });
  });
  test('Pobranie profilu administratora.',function(done){
    user1.get(port+'/api/profile').end(function(res){
        assert.equal(res.status,200);
      done();
    });
  });
  test('Wysłanie aplikacji dla użytkownika 3@3.com.', function(done){
    user1.post(port+'/api/application').send(user3).end(function(res){
      assert.equal(res.status,200);
      userId = res.body._id;
      done();
    });

  });
  test('Wylogowanie administratora.',function(done){
    user1.post(port+'/api/logout').end(function(res){
        assert.equal(res.status,200);
      done();
    });
  });
  test('Ponowne pobranie profilu po wylogowaniu.',function(done){
    user1.get(port+'/api/profile').end(function(res){
        assert.equal(res.status,500);
      done();
    });
  });
  test('Zalogowanie jako user3 - niezatwierdzony użytkownik.', function(done){
    user1.post(port+'/api/login').send({email:'3@3.com', password:'3'}).end(function(res){
        assert.equal(res.status, 200);
      done();
    });
  });
  test('Pobranie aplikacji użytkownika.', function(done){
    user1.get(port+'/api/application/').end(function(res){
      // console.log(res.body)
      assert.equal(res.status, 200);
      done();
    });
  });
  test('Uaktualnienie aplikacji użytkownika.', function(done){
    user1.put(port+'/api/application/').send({
      firstName: 'boo'}).end(function(res){
      // console.log(res.body)
      assert.equal(res.status, 200);
      done();
    });
  });
  test('Pobranie aplikacji użytkownika.', function(done){
    user1.get(port+'/api/application/').end(function(res){
      // console.log(res.body)
      assert.equal(res.status, 200);
      done();
    });
  });
  test('Sprawdzenie pod kątem postów - niepowodzenie (niezatwierdzony?)', function(done){
    user1.get(port+'/api/posts/').end(function(res){
      // console.log(res.body)
      assert.equal(res.status, 500);

      done();
    });
  });
  test('Wylogowanie użytkownika',function(done){
    user1.post(port+'/api/logout').end(function(res){
        assert.equal(res.status,200);
      done();
    });
  });
  test('Zalogowanie jako administrator.', function(done){
    user1.post(port+'/api/login').send(adminUser).end(function(res){
        assert.equal(res.status,200);
      done();
    });
  });
  test('Usunięcie user3.', function(done){
    user1.del(port+'/api/users/'+userId).end(function(res){
      assert.equal(res.status, 200);
      done();
    });
  });
  test('Wylogowanie administratora',function(done){
    user1.post(port+'/api/logout').end(function(res){
        assert.equal(res.status,200);
      done();
    });
  });
  test('Zalogowanie jako użytkownik - powinno zakończyć się niepowodzeniem.', function(done){
    user1.post(port+'/api/login').send({email:'3@3.com',password:'3'}).end(function(res){
      // console.log(res.body)
        assert.equal(res.status,500);

      done();
    });
  });
  test('Sprawdzenie pod kątem postów - musi zakończyć się niepowodzeniem.', function(done){
    user1.get(port+'/api/posts/').end(function(res){
      // console.log(res.body)
      assert.equal(res.status, 500);

      done();
    });
  });
  suiteTeardown(function(done){
    done();
  });

});
