const METoken = artifacts.require("METoken");

contract('METoken', accounts => {

  beforeEach(async function () {
    InstanceMEToken = await METoken.new();
  });

  it('Ma nazwe', async function () {
    const name = await InstanceMEToken.name();
    assert.notEqual(name, "", "Nazwa tokenu nie powinna być pusta");
  });

  it('Ma symbol', async function () {
    const symbol = await InstanceMEToken.symbol();
    assert.notEqual(symbol, "", "Symbol tokenu nie powinien być pusty");
  });

  it('Ma ustawione pole decimals', async function () {
    const decimals = await InstanceMEToken.decimals();
    assert.notEqual(decimals, "", "Pole decimals nie powinno być puste");
  });

  it('Własciciel posiada 2100000000', async function () {
    const balance = await InstanceMEToken.balanceOf(accounts[0]);
    assert.equal(balance, 2100000000, "Właściciel nie posiada 2100000000");
  });
});