const axios = require("axios")
const url = "http://172.16.163.129:8545"

const requests = [
  {
    // Pobieranie aktualnego numeru bloku
    jsonrpc: "2.0",
    method: "eth_blockNumber",
    params: [],
    id: 1234
  },
  {
    // Pobieranie kont z danego węzła
    jsonrpc: "2.0",
    method: "eth_accounts",
    params: [],
    id: 12345
  }
]

requests.map(async (request) => {
  try {
    // Przesyłanie żądania
    console.log("Wywołanie: ", request.method)
    const result = await axios.post(url, request)

    // Sprawdzanie błędów
    if(result.data.error) 
      console.log("Błąd: ", result.data.error.message)
    else
      console.log("Odpowiedź węzła Ethereum: ", result.data)
  } catch (e) {
    console.log("Błąd przy próbie połączenia się ze zdalnym serwerem", e)
  }

})