var FaucetContract = artifacts.require("Faucet.sol");

FaucetContract.web3.eth.getGasPrice(function(error, result) {
    var gasPrice = Number(result);
    console.log("Cena paliwa w wei: " + gasPrice + "."); // "10000000000000"

    // Get the contract instance
    FaucetContract.deployed().then(function(FaucetContractInstance) {

        // Use the keyword 'estimateGas' after the function name to get the gas estimation for this particular function (aprove)
		FaucetContractInstance.send(web3.toWei(1, "ether"));
        return FaucetContractInstance.withdraw.estimateGas(web3.toWei(0.1, "ether"));

    }).then(function(result) {
        var gas = Number(result);

        console.log("Szacowane zużycie paliwa = " + gas + " (w jednostkach)");
        console.log("Szacowany koszt paliwa = " + (gas * gasPrice) + " (w wei)");
        console.log("Szacowany koszt paliwa = " + FaucetContract.web3.fromWei((gas * gasPrice), 'ether') + " (w etherach)");
    });
});
