# Konfigurowanie platformy truffle
# Informacje o tym, jak poprawnie skonfigurować platformę truffle na potrzeby budowania i instalowania kontraktów w sieci


## Dodawanie lokalnej sieci testowej

Edit `truffle.js` :

```
  networks: {
    development: {
      host: "",
      port: 8545,
      network_id: "*",
      gas: 2900000
    }
  }
```

## Instrukcje

```
$ truffle init #initialize truffle project
$ truffle console
$ truffle deploy
$ truffle migrate --reset --compile-all # Ponowna instalacja inteligentnych kontraktów

```

## Błędy
# Oto lista możliwych błędów:

## ParserError: Expected token Semicolon got 'LParen'

# Generowanie zdarzeń powoduje błąd kompilacji, jeśli solc-js ma wersję inną niż 0.4.21
# Zaktualizuj platformę truffle za pomocą:

```
$ cd /usr/lib/node_modules/truffle
$ npm install solc@0.4.21 --save
```

### Konto zablokowane/wymagane uwierzytelnienie

```
$ truffle console
truffle(development)> var acc = web3.eth.accounts[0]
truffle(development)> web3.personal.unlockAccount(acc, 'pass', 36000)
```

# Następnie instaluj oprogramowanie. W razie potrzeby powtórz ten krok.

### Za mało paliwa.

```
$ truffle console
truffle(development)> web3.eth.getBlock("pending").gasLimit
xxxxxxx
```

edit truffle.js

```
    development: {
        ...
        gas: xxxxxxxxx,
        network_id: "*"
    }
```
