package com.titan.access;

import javax.persistence.*;
import javax.ejb.*;
import java.io.*;

import com.titan.domain.*;
import java.util.List;
import java.util.Date;


@Stateless
public class DataAccessBean implements DataAccess
{
   @PersistenceContext(unitName="titan") EntityManager manager;
   
   public List fetchReservations()
   {
      return manager.createQuery("FROM Reservation res").getResultList();
   }

   public List fetchReservationsWithRelationships()
   {
      List list = manager.createQuery("FROM Reservation res").getResultList();
      for (Object obj : list)
      {
         Reservation res = (Reservation)obj;
         res.getCabins().size();
         res.getCustomers().size();
      }
      return list;
   }

   public String initializeDatabase()
   {
      List list = manager.createQuery("FROM Reservation res").getResultList();
      if (list.size() > 0) 
      {
         return "Encje zostay ju zainicjalizowane w bazie danych.";
      }
      

      String output = null;
      StringWriter writer = new StringWriter();
      PrintWriter out = new PrintWriter(writer);
      
      Customer bill = new Customer();
      bill.setFirstName("Bartosz");
      bill.setLastName("Biernacki");
      bill.setHasGoodCredit(true);

      Customer sacha = new Customer();
      sacha.setFirstName("Sebastian");
      sacha.setLastName("Libicki");
      sacha.setHasGoodCredit(false); // Sebastian ma kiepsk zdolno kredytow ;)

      Customer marc = new Customer();
      marc.setFirstName("Marcin");
      marc.setLastName("Florczak");
      marc.setHasGoodCredit(true);

      Address addr = new Address();
      addr.setStreet("ul. Biaostocka 123");
      addr.setCity("Bytom");
      addr.setState("lskie");
      addr.setZip("01-821");
      bill.setAddress(addr);

      addr = new Address();
      addr.setStreet("al. Niepodlegoci 2");
      addr.setCity("Niepoomice");
      addr.setState("Maopolskie");
      addr.setZip("07-711");
      sacha.setAddress(addr);

      addr = new Address();
      addr.setStreet("pl. Gwny 4");
      addr.setState("Wrocaw");
      addr.setCity("Dolnolskie");
      addr.setZip("06-660");
      marc.setAddress(addr);

      CreditCard cc;
      cc = new CreditCard();
      cc.setExpirationDate(new Date());
      cc.setNumber("5324 9393 1010 2929");
      cc.setNameOnCard("Bartosz Biernacki");
      cc.setCreditOrganization("Capital One");
      bill.setCreditCard(cc);

      cc = new CreditCard();
      cc.setExpirationDate(new Date());
      cc.setNumber("3311 5000 1011 2333");
      cc.setNameOnCard("Sebastian Libicki");
      cc.setCreditOrganization("American Express");
      sacha.setCreditCard(cc);

      cc = new CreditCard();
      cc.setNumber("4310 5131 7711 2663");
      cc.setNameOnCard("Marcin Florczak");
      cc.setCreditOrganization("MBNA");
      marc.setCreditCard(cc);

      out.println("dodano klienta Bartosz Biernacki");
      manager.persist(bill);
      out.println("dodano klienta Sebastian Libicki");
      manager.persist(sacha);
      out.println("dodano klienta Marcin Florczak");
      manager.persist(marc);

      Ship queenMary = new Ship("Queen Mary", 40.0);
      manager.persist(queenMary);
      out.println("dodano statek Query Mary");
      Ship titanic = new Ship("Titanic", 80.0);
      manager.persist(titanic);
      out.println("dodano statek Titanic");
      
      // Tworzy kajuty
      Cabin cabin1 = new Cabin();
      cabin1.setDeckLevel(1);
      cabin1.setShip(queenMary);
      cabin1.setBedCount(1);
      cabin1.setName("Kajuta Krlowej 1");
      manager.persist(cabin1);
      out.println("Dodano Kajuta Krlowej 1 do statku Queen Mary");

      Cabin cabin2 = new Cabin();
      cabin2.setDeckLevel(1);
      cabin2.setShip(queenMary);
      cabin2.setBedCount(1);
      cabin2.setName("Kajuta Krlowej 2");
      manager.persist(cabin2);
      out.println("Dodano Kajuta Krlowej 2 do statku Queen Mary");
         
      Cabin cabin3 = new Cabin();
      cabin3.setDeckLevel(1);
      cabin3.setShip(titanic);
      cabin3.setBedCount(2);
      cabin3.setName("Kajuta Titanica 1");
      manager.persist(cabin3);
      out.println("Dodano Kajuta Titanica 1 do statku Titanic");
         
      Cabin cabin4 = new Cabin();
      cabin4.setDeckLevel(1);
      cabin4.setShip(titanic);
      cabin4.setBedCount(2);
      cabin4.setName("Kajuta Titanica 2");
      manager.persist(cabin4);
      out.println("Dodano Kajuta Titanica 2 do statku Titanic");
         
      Cabin cabin5 = new Cabin();
      cabin5.setDeckLevel(1);
      cabin5.setShip(titanic);
      cabin5.setBedCount(2);
      cabin5.setName("Kajuta Titanica 3");
      manager.persist(cabin5);
      out.println("Dodano Kajuta Titanica 3 do statku Titanic");

      // Tworzy rejsy
      Cruise alaskan = new Cruise("Rejs Alaskaski", queenMary);
      manager.persist(alaskan);
      out.println("dodano Rejs Alaskaski dla statku Queen Mary");
      Cruise atlantic = new Cruise("Rejs Atlantycki", titanic);
      manager.persist(atlantic);
      out.println("dodano Rejs Atlantycki dla statku Titanic");

      Reservation alaskanReservation = new Reservation();
      alaskanReservation.setCruise(alaskan);
      alaskanReservation.getCabins().add(cabin1);
      alaskanReservation.getCabins().add(cabin2);
      alaskanReservation.getCustomers().add(bill);
      alaskanReservation.getCustomers().add(sacha);
      manager.persist(alaskanReservation);
      out.println("Zarezerwowano bilety dla klientw Bartosz and Sebastian na Rejs na Alask w kajutach 1 i 2");
      
      Reservation atlanticReservation = new Reservation();
      atlanticReservation.setCruise(atlantic);
      atlanticReservation.getCabins().add(cabin3);
      atlanticReservation.getCustomers().add(marc);
      manager.persist(atlanticReservation);
      out.println(Zarezerwowano bilety dla klienta Marek w kajucie 1 na Rejs Atlantycki statku Titanic. Pozdrw od nas Leonardo!");

      out.close();
      output = writer.toString();

      return output;
   }
}

