package com.titan.travelagent;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import com.titan.domain.Customer; 

@Stateless
public class TravelAgentBean implements TravelAgentRemote
{
   @PersistenceContext(unitName="titan") private EntityManager manager;
    
   public int createCustomer(Customer cust)
   {
      System.out.println("--------------------------------------");
      System.out.println("Wywoanie createCustomer():" + cust.getFirstName());
      System.out.println("Wywoanie manager.persist()");
      manager.persist(cust);
      System.out.println("Koniec wykonywania metody createCustomer()");
      return cust.getId();
   }

   public Customer findCustomer(int pKey)
   {
      System.out.println("--------------------------------------");
      System.out.println("Wywoanie findCustomer()");
      System.out.println("Wywoanie manager.find()");
      Customer cust = manager.find(Customer.class, pKey);
      System.out.println("Warto zwracana przez findCustomer(): " + cust.getFirstName());
      return cust;
   }

   public void doMerge(Customer cust)
   {
      System.out.println("--------------------------------------");
      System.out.println("Wywoanie doMerge()");
      manager.merge(cust);
      System.out.println("Koniec wykonywania metody doMerge()");
   }

   public void doFlush(int pKey)
   {
      System.out.println("--------------------------------------");
      System.out.println("Wywoanie doFlush()");
      System.out.println("Wywoanie manager.find()");
      Customer cust = manager.find(Customer.class, pKey);
      System.out.println("Wywoanie cust.setName()");
      cust.setFirstName("doFlush");
      System.out.println("Wywoanie manager.flush()");
      manager.flush();
      System.out.println("Koniec wykonywania metody doFlush()");
   }

   public void doRemove(int pKey)
   {
      System.out.println("--------------------------------------");
      System.out.println("Wywoanie doRemove()");
      System.out.println("Wywoanie manager.find()");
      Customer cust = manager.find(Customer.class, pKey);
      System.out.println("Wywoanie manager.remove()");
      manager.remove(cust);
      System.out.println("Koniec wykonywania metody doRemove()");
   }
      
}
